{$R-}
{$Q-}
{$S-}
{$E-}

UNIT XVGA6;

INTERFACE

USES DOS;

const
  tcountz : integer =0;
  maxmis = 40;
  dostarsq : boolean = true;
  osc   : integer =10;
  score : integer =0;
  isthisscore : boolean = false;
  doonemoretime : boolean = false;
  maxsprites =50;
  _TOPCLIP: integer=15;{15}
  _BOTTOMCLIP:integer=238{199};
  _LEFTCLIP:integer=8;
  _RIGHTCLIP:integer=76;
  botherwithscore: boolean = true;
  CRTC = $3D4;
  SEQU = $3C4;
  GRAC = $3CE;


type
  vv = array[0..60000] of byte;
  vvp = ^vv;
  screen_type = array[0..0,0..100,0..142] of byte;
  spritetype = record
                    x,y:integer;
                    shape : pointer;
                  end;
VAR
  timeguess : integer;
  flickar : array[15..238] of integer;
  sgg1,sgg2,off1,off2 : word;
  sprite : array[0..maxsprites] of spritetype;
  star_screen : ^screen_type;
  spritestack : array[0..3,0..maxmis] of record
                                       zsprite : vvp;
                                       zoffs,zw,zh : word;
                                       zx,zy : integer;
                                       zinvs : boolean;
                                       score : boolean;
                                      end;
  MISstack : array[0..3,0..maxmis] of record
                                       zsprite : vvp;
                                       zoffs,zw,zh : word;
                                       zx,zy : integer;
                                       zinvs : boolean;
                                      end;
  MISstack2 : array[0..3,0..maxmis] of record
                                       zsprite : vvp;
                                       zoffs,zw,zh : word;
                                       zx,zy : integer;
                                       zinvs : boolean;
                                      end;

  MISstacktop : integer;
  MISstacktop2 : integer;
  SPRITESTACKTOP : INTEGER;
  _pnts : array[0..480] of record
                             x,y:integer;
                           end;

  slowmachine : boolean;
  _INGRAPHICS : BYTE;
  _CURRXMODE,
  _SCRNPHYSICALBYTEWIDTH,
  _SCRNPHYSICALPIXELWIDTH,
  _SCRNPHYSICALHEIGHT,
  _ERRORVALUE,
  _SPLITSCRNOFFS,
  _SPLITSCRNSCANLINE,
  _SPLITSCRNVISIBLEHEIGHT,
  _PAGE0_OFFS,
  _PAGE1_OFFS,
  _PAGE2_OFFS,
  _SCRNLOGICALBYTEWIDTH,
  _SCRNLOGICALPIXELWIDTH,
  _SCRNLOGICALHEIGHT,
  _MAXSCROLLX,
  _MAXSCROLLY,
  _DOUBLEBUFFERACTIVE,
  _TRIPPLEBUFFERACTIVE,
  _VISIBLEPAGEIDX,
  _HIDDENPAGEOFFS,
  _VISIBLEPAGEOFFS,
  _WAITINGPAGEOFFS,
  _NONVISUAL_OFFS,
  _STARTADDRESSFLAG,
  _PHYSICALSTARTPIXELX,
  _PHYSICALSTARTBYTEX,
  _PHYSICALSTARTY       : WORD;
  _VSYNCPALETTEBUFFER : ^BYTE;
  _NONACTIVEPAGEOFFS : WORD;
  xxxpos,yyypos : real;



procedure sfillchar(sg:word;ff:word;count:word;value:byte);
procedure nodrawflip;
procedure SETVISIBLESTART(OO:WORD);
PROCEDURE SET320X200X256_X;
PROCEDURE SET320X240X256_X;
PROCEDURE PPIX_X(X,Y:INTEGER;COLOR : BYTE);
function rpix_x(x,y:integer):byte;
PROCEDURE FLIP;
PROCEDURE CLEARPAGE;
procedure copybitmap(sprite:vvp;x,y:integer;invs : boolean);
procedure copyMISmap(sprite:vvp;x,y:integer;invs : boolean);
procedure copyMISmap2(sprite:vvp;x,y:integer;invs : boolean);
procedure flickinscreen;

IMPLEMENTATION



procedure SETVISIBLESTART(OO:WORD);
BEGIN
  _VISIBLEPAGEOFFS:=OO;
  PORT[CRTC]:=$0C;
  PORT[CRTC+1]:=BYTE(OO SHR 8);
{  PORT[CRTC]:=$0D;
  PORT[CRTC+1]:=BYTE(oo AND $FF);}

END;

{PROCEDURE SETACTIVEPAGE(PAGE:WORD);
BEGIN
  _HIDDENPAGEOFFS:=(PAGE-1)*(80*240);
END;

PROCEDURE SETVISIBLEPAGE(PAGE:WORD);
BEGIN
  SETVISIBLESTART((PAGE-1)*(80*240));
END;                                 }


procedure sfillchar(sg:word;ff:word;count:word;value:byte); assembler;
label loopz;

asm
  mov ax,4    {count}
  shr ax,1
  mov cx,ax              {cx now has count div 2}

  mov es,sg
  mov si,ff

  mov ah,value
  mov al,value

loopz:
  mov [es:si],ax
  add si,2
  loop loopz

  mov ax,ff
  add ax,count
  dec ax
  mov si,ax
  mov al,value
  mov [es:si],al
end;


procedure flickinscreen;
var i,j,k : integer;
    fini : boolean;
    sttk : integer;

begin
  for i:=_topclip to _bottomclip do
    flickar[i]:=-1;


  repeat
    tcountz:=0;
    fini:=true;
    sttk:=-1;
    for i:=_topclip to _topclip+60 do
      if (random(2)=0) and (flickar[i]<140) then
        begin
          inc(flickar[i]);

          inc(sttk);
          _pnts[sttk].x:=(_leftclip+_rightclip)*2-flickar[i];
          _pnts[sttk].y:=i;

          inc(sttk);
          _pnts[sttk].x:=(_leftclip+_rightclip)*2+flickar[i];
          _pnts[sttk].y:=i;
          fini:=false;
        end;

    for j:=0 to 3 do
     begin
       PORT[$3C4]:=$02;
       PORT[$3C5]:=$01 SHL (j AND 3);

       port[grac]:=$04;
       port[grac+1]:=j and 3;

       for i:=0 to sttk do
          begin
            if ((_pnts[i].x and 3)=j) and (_pnts[i].x<_rightclip*4) then
            mem[sega000:_visiblepageoffs+80*_pnts[i].y+(_pnts[i].x div 4)]:=
            mem[sega000:_nonactivepageoffs+80*_pnts[i].y+(_pnts[i].x div 4)];
          end;
     end;
     while tcountz=0 do;
    until fini;


    repeat
    tcountz:=0;
    fini:=true;
    sttk:=-1;
    for i:=_topclip+61 to _topclip+98 do
      if (random(2)=0) and (flickar[i]<140) then
        begin
          inc(flickar[i]);

          inc(sttk);
          _pnts[sttk].x:=(_leftclip+_rightclip)*2-flickar[i];
          _pnts[sttk].y:=i;

          inc(sttk);
          _pnts[sttk].x:=(_leftclip+_rightclip)*2+flickar[i];
          _pnts[sttk].y:=i;
          fini:=false;
        end;

    for j:=0 to 3 do
     begin
       PORT[$3C4]:=$02;
       PORT[$3C5]:=$01 SHL (j AND 3);

       port[grac]:=$04;
       port[grac+1]:=j and 3;

       for i:=0 to sttk do
          begin
            if ((_pnts[i].x and 3)=j) and (_pnts[i].x<_rightclip*4) then
            mem[sega000:_visiblepageoffs+80*_pnts[i].y+(_pnts[i].x div 4)]:=
            mem[sega000:_nonactivepageoffs+80*_pnts[i].y+(_pnts[i].x div 4)];
          end;
     end;






        while tcountz=0 do;
  until fini;



    repeat
    tcountz:=0;
    fini:=true;
    sttk:=-1;
    for i:=_topclip+99 to _bottomclip do
      if (random(2)=0) and (flickar[i]<140) then
        begin
          inc(flickar[i]);

          inc(sttk);
          _pnts[sttk].x:=(_leftclip+_rightclip)*2-flickar[i];
          _pnts[sttk].y:=i;

          inc(sttk);
          _pnts[sttk].x:=(_leftclip+_rightclip)*2+flickar[i];
          _pnts[sttk].y:=i;
          fini:=false;
        end;

    for j:=0 to 3 do
     begin
       PORT[$3C4]:=$02;
       PORT[$3C5]:=$01 SHL (j AND 3);

       port[grac]:=$04;
       port[grac+1]:=j and 3;

       for i:=0 to sttk do
          begin
            if ((_pnts[i].x and 3)=j) and (_pnts[i].x<_rightclip*4) then
            mem[sega000:_visiblepageoffs+80*_pnts[i].y+(_pnts[i].x div 4)]:=
            mem[sega000:_nonactivepageoffs+80*_pnts[i].y+(_pnts[i].x div 4)];
          end;
     end;






         while tcountz=0 do;
  until fini;

end;



PROCEDURE SET320X200X256_X;
VAR REG:REGISTERS;
    PP :^BYTE;
BEGIN
  PP:=PTR(SEGA000,0);
  REG.ax := $13;

  INTR($10,REG);

  PORTW[SEQU]:=$0604;
  PORTW[CRTC]:=$E317;
  PORTW[CRTC]:=$0014;
  PORTW[SEQU]:=$0F02;
  FILLCHAR(PP^,$FFFF,0);
  MEM[SEGA000:0]:=0;

  _SCRNPHYSICALBYTEWIDTH:=320 DIV 4;
  _scrnlogicalbytewidth:=320 div 4;


  _HIDDENPAGEOFFS:=0;
  _VISIBLEPAGEOFFS:=(80*256);
{  _WAITINGPAGEOFFS:=(80*256);}
{  _NONACTIVEPAGEOFFS:=(80*512);}
  setvisiblestart(_VISIBLEPAGEOFFS);
  PORT[CRTC]:=$0D;
  PORT[CRTC+1]:=BYTE(_visiblepageoffs AND $FF);


END;

PROCEDURE CLEARPAGE;
VAR PP:^BYTE;
BEGIN
  PORTW[SEQU]:=$0F02;
  PP:=PTR(SEGA000,0{_HIDDENPAGEOFFS});
  FILLCHAR(PP^,{(80*241)}65535,63);
END;

PROCEDURE SET320X240X256_X;
BEGIN
  SET320X200X256_X;
  PORT[$3C2]:=$E3;

  PORTW[$3D4]:=$2C11;
  PORTW[$3D4]:=$0D06;
  PORTW[$3D4]:=$3E07;
  PORTW[$3D4]:=$EA10;
  PORTW[$3D4]:=$AC11;
  PORTW[$3D4]:=$DF12;
  PORTW[$3D4]:=$E715;
  PORTW[$3D4]:=$0616;
  _HIDDENPAGEOFFS:=0;
  _VISIBLEPAGEOFFS:=(80*256);
{  _WAITINGPAGEOFFS:=(80*256);}
  _NONACTIVEPAGEOFFS:=(80*512);
  setvisiblestart(_VISIBLEPAGEOFFS);

END;

PROCEDURE PPIX_X(X,Y:INTEGER;COLOR : BYTE);
BEGIN
  PORT[$3C4]:=$02;
  PORT[$3C5]:=$01 SHL (X AND 3);
  MEM[SEGA000:(_SCRNPHYSICALBYTEWIDTH*Y)+(X DIV 4)+_HIDDENPAGEOFFS]:=COLOR;
END;


procedure fmoves(ssg,sof,dsg,dof:word); assembler;
 asm
   mov ax,ds
   cld
   mov si,sof
   mov di,dof
   mov es,dsg
   mov bx,ssg
   mov cx,17    { 36} {word ptr[len]}
   mov ds,bx

{   movsb}
{   movsw }
   db $66
   rep movsw

   movsb
{   movsw}

   mov ds,ax
end;



function rpix_x(x,y:integer):byte;
begin
{  port[grac]:=$04;
  port[grac+1]:=x and 3;}
  rpix_x:=mem[SEGA000:(_scrnphysicalbytewidth*y)+(x div 4)+_VISIBLEpageoffs];
end;

procedure dodraw(sprite:vvp;offs:word;w,h:integer;x,y:integer);
var minx,miny,maxx,maxy:integer;
    difx,dify : integer;
    stx : word;
    stxh : word;
    ominx,ominy,z_topclip : integer;
    segword : word;
label
    _Redraw, _DrawLoop, _Exit, _LineLoop, _NextLine, _Storebyte, _NoPaint,
      _storeword,_lineloopword;

begin
  segword:=sega000;
  minx:=x;
  miny:=y;
  maxx:=x+w-1;
  maxy:=y+h-1;
  ominx:=minx;
  ominy:=miny;
  z_topclip:=_topclip+1;
  if minx<_leftclip then minx:=_leftclip else
    if minx>_rightclip then exit;
  if maxx>_rightclip then maxx:=_rightclip else
    if maxx<_leftclip then exit;
  if miny<z_topclip then miny:=z_topclip else
    if miny>_bottomclip then exit;
  if maxy>_bottomclip then maxy:=_bottomclip else
    if maxy<z_topclip then exit;

  stx:=(x+minx-ominx)+80*(y+miny-ominy);
  stxh:=(minx-ominx)+(miny-ominy)*w+offs;

  difx:=maxx-minx+1;
  dify:=maxy-miny+1;
  if difx<1 then exit;
  if dify<1 then exit;

  asm
    cld
    mov ax,segword
    mov es,ax
    mov ax,_hiddenpageoffs
    add ax,stx
    mov di,ax                           {es:di = first pixel on screen }

    mov ax,stxh
    add ax,word(sprite)
    mov si,ax                           {si = offset of first array point}


    mov cx,dify
    MOV DX,DIFX
    MOV BX,W
    SUB BX,DX

    PUSH DS
    MOV AX,WORD(SPRITE+2)
    MOV DS,AX


_DrawLoop:
    MOV AH,CL
    mov cx,DX

_lineloop:
    mov al,byte ptr[si]                 {al = pixel to be drawn}
    TEST Al,$FF
    jz _nopaint
    test cx,1
    jnz _storebyte

    mov al,byte ptr[si+1]
    test al,$ff
    jz _storebyte
    jmp _storeword

_lineloopword:
    mov al,byte ptr[si]                 {al = pixel to be drawn}
    TEST Al,$FF
    jz _nopaint
    mov al,byte ptr[si+1]
    test al,$ff
    jz _storebyte

_storeword:
    movsw
    dec cx
    jz _nextline
    loop _lineloopword
    jmp _nextline



_nopaint:
    inc si
    inc di
    loop _lineloop
{    jmp _nextline}

    MOV CL,AH

    add di,80                           {increment screen pointer by 1 line}
    SUB DI,DX
    add si,BX                            {increment array pointer by 1 width}
    loop _drawloop
    jmp _exit

_storebyte:
{    mov ax,word(sprite+2)
    mov bx,ds
    mov ds,ax}
    {movsb}
{    mov al,byte ptr[si]
    mov ds,bx
    mov [es:di],al
    jmp _nopaint}

    movsb
{    MOV [ES:DI],AL
    INC SI
    INC DI}
    loop _lineloop

_nextline:
    MOV CL,AH

    add di,80                           {increment screen pointer by 1 line}
    SUB DI,DX
    add si,BX                            {increment array pointer by 1 width}
    loop _drawloop
_exit:
    POP DS

  end;
end;


procedure dodraw2(sprite:vvp;offs:word;w,h:integer;x,y:integer);
var minx,miny,maxx,maxy:integer;
    difx,dify : integer;
    stx : word;
    stxh : word;
    ominx,ominy,z_topclip : integer;
    segword : word;
label
    _Redraw, _DrawLoop, _Exit, _LineLoop, _NextLine, _Storebyte, _NoPaint,
      _storeword,_lineloopword;

begin
  segword:=sega000;
  minx:=x;
  miny:=y;
  maxx:=x+w-1;
  maxy:=y+h-1;
  ominx:=minx;
  ominy:=miny;
  z_topclip:=_topclip+1;
  if minx<_leftclip then minx:=_leftclip else
    if minx>_rightclip then exit;
  if maxx>_rightclip then maxx:=_rightclip else
    if maxx<_leftclip then exit;
  if miny<z_topclip then miny:=z_topclip else
    if miny>_bottomclip then exit;
  if maxy>_bottomclip then maxy:=_bottomclip else
    if maxy<z_topclip then exit;

  stx:=(x+minx-ominx)+80*(y+miny-ominy);
  stxh:=(minx-ominx)+(miny-ominy)*w+offs;

  difx:=maxx-minx+1;
  dify:=maxy-miny+1;
  if difx<1 then exit;
  if dify<1 then exit;

  asm
    cld
    mov ax,segword
    mov es,ax
    mov ax,_hiddenpageoffs
    add ax,stx
    mov di,ax                           {es:di = first pixel on screen }

    mov ax,stxh
    add ax,word(sprite)
    mov si,ax                           {si = offset of first array point}


    mov cx,dify
    MOV DX,DIFX
    MOV BX,W
    SUB BX,DX

    PUSH DS
    MOV AX,WORD(SPRITE+2)
    MOV DS,AX


_DrawLoop:
    MOV AH,CL
    mov cx,DX

_lineloop:

    rep movsb
{    loop _lineloop}

_nextline:
    MOV CL,AH

    add di,80                           {increment screen pointer by 1 line}
    SUB DI,DX
    add si,BX                            {increment array pointer by 1 width}
    loop _drawloop
_exit:
    POP DS

  end;
end;

procedure dodrawnoclip(sprite:vvp;offs:word;w,h:integer;x,y:integer);
var minx,miny,maxx,maxy:integer;
    difx,dify : word;
    stx : word;
    stxh : word;
    ominx,ominy,z_topclip : integer;
    segword : word;
label
    _Redraw, _DrawLoop, _Exit, _LineLoop, _NextLine, _Store, _NoPaint;

begin
  segword:=sega000;
  minx:=x;
  miny:=y;
  maxx:=x+w-1;
  maxy:=y+h-1;
  ominx:=minx;
  ominy:=miny;

  stx:=(x+minx-ominx)+80*(y+miny-ominy);
  stxh:=(minx-ominx)+(miny-ominy)*w+offs;

  difx:=maxx-minx+1;
  dify:=maxy-miny+1;
  if difx<1 then exit;
  if dify<1 then exit;

  asm
    cld
    mov ax,segword
    mov es,ax
    mov ax,_hiddenpageoffs
    add ax,stx
    mov di,ax                           {es:di = first pixel on screen }

    mov ax,stxh
    add ax,word(sprite)
    mov si,ax                           {si = offset of first array point}


    mov cx,dify
    MOV DX,DIFX
    MOV BX,W
    SUB BX,DX

    PUSH DS
    MOV AX,WORD(SPRITE+2)
    MOV DS,AX


_DrawLoop:
    MOV AH,CL
    mov cx,DX

_lineloop:
    mov al,byte ptr[si]                 {al = pixel to be drawn}
    TEST AL,$FF
    jnz _store

_nopaint:
    inc si
    inc di
    loop _lineloop
{    jmp _nextline}

    MOV CL,AH

    add di,80                           {increment screen pointer by 1 line}
    SUB DI,DX
    add si,BX                            {increment array pointer by 1 width}
    loop _drawloop
    jmp _exit

_store:
{    mov ax,word(sprite+2)
    mov bx,ds
    mov ds,ax}
    {movsb}
{    mov al,byte ptr[si]
    mov ds,bx
    mov [es:di],al
    jmp _nopaint}

    movsb
{    MOV [ES:DI],AL
    INC SI
    INC DI}
    loop _lineloop

_nextline:
    MOV CL,AH

    add di,80                           {increment screen pointer by 1 line}
    SUB DI,DX
    add si,BX                            {increment array pointer by 1 width}
    loop _drawloop
_exit:
    POP DS

  end;
end;


procedure doinvs(sprite:vvp;offs:word;w,h:integer;x,y:integer);
var minx,miny,maxx,maxy:integer;
    difx,dify : word;
    stx : word;
    stxh : word;
    ominx,ominy : integer;
    ggg2 : longint;
    ggg : word;
label
    _Redraw, _DrawLoop, _Exit, _LineLoop, _NextLine, _Store, _NoPaint;

begin
  minx:=x;
  miny:=y;
  maxx:=x+w-1;
  maxy:=y+h-1;
  ominx:=minx;
  ominy:=miny;
  if minx<_leftclip then minx:=_leftclip else
    if minx>_rightclip then exit;
  if maxx>_rightclip then maxx:=_rightclip else
    if maxx<_leftclip then exit;
  if miny<(_topclip+1) then miny:=(_topclip+1) else
    if miny>_bottomclip then exit;
  if maxy>_bottomclip then maxy:=_bottomclip else
    if maxy<(_topclip+1) then exit;
  stx:=(x+minx-ominx)+80*(y+miny-ominy);
  stxh:=(minx-ominx)+(miny-ominy)*w+offs;
  difx:=maxx-minx+1;
  dify:=maxy-miny+1;
  ggg2:=-_hiddenpageoffs+_visiblepageoffs;
  if ggg2<0 then ggg2:=ggg2+(65536);
  ggg:=word(ggg2);

  asm
    cld
{    mov ax,$A000
    mov es,ax}
    mov ax,ggg;
    mov es,ax
    mov ax,_hiddenpageoffs
    add ax,stx
    mov di,ax                           {es:di = first pixel on screen }

    mov ax,stxh
    add ax,word(sprite)
    mov si,ax                           {si = offset of first array point}


    mov cx,dify
    MOV DX,DIFX
    PUSH DS
    MOV AX,WORD(SPRITE+2)
    MOV DS,AX
    MOV BX,W
    SUB BX,DX

_DrawLoop:
    MOV AH,CL
    mov cx,DX

_lineloop:
    mov al,byte ptr[si]                 {al = pixel to be drawn}
    TEST AL,$FF
    jnz _store

_nopaint:
    inc si
    inc di
    loop _lineloop
    jmp _nextline

_store:
{    mov ax,word(sprite+2)
    mov bx,ds
    mov ds,ax}
    {movsb}
{    mov al,byte ptr[si]
    mov ds,bx
    mov [es:di],al
    jmp _nopaint}

{    movsb}

{    push bx
    mov bl,[es:di]
    shr al,3
    and al,$03
    add al,bl


    pop bx}

    push es
    push ax
    push di

    mov ax,es
    add ax,di
    mov di,ax

    mov ax,$A000
    mov es,ax
    mov ax,[es:di]
    or ax,$01
    and ax,127
    pop di
    MOV [ES:DI],al
    pop ax
    pop es

    INC SI
    INC DI
    loop _lineloop

_nextline:
    MOV CL,AH

    add di,80                           {increment screen pointer by 1 line}
    SUB DI,DX
    add si,BX                            {increment array pointer by 1 width}
    loop _drawloop
    POP DS
  end;
end;

procedure dopurp(sprite:vvp;offs:word;w,h:integer;x,y:integer);
var minx,miny,maxx,maxy:integer;
    difx,dify : word;
    stx : word;
    stxh : word;
    ominx,ominy : integer;
    ggg2 : longint;
    ggg : word;
label
    _Redraw, _DrawLoop, _Exit, _LineLoop, _NextLine, _Store, _NoPaint;

begin
  minx:=x;
  miny:=y;
  maxx:=x+w-1;
  maxy:=y+h-1;
  ominx:=minx;
  ominy:=miny;
  if minx<_leftclip then minx:=_leftclip else
    if minx>_rightclip then exit;
  if maxx>_rightclip then maxx:=_rightclip else
    if maxx<_leftclip then exit;
  if miny<(_topclip+1) then miny:=(_topclip+1) else
    if miny>_bottomclip then exit;
  if maxy>_bottomclip then maxy:=_bottomclip else
    if maxy<(_topclip+1) then exit;
  stx:=(x+minx-ominx)+80*(y+miny-ominy);
  stxh:=(minx-ominx)+(miny-ominy)*w+offs;
  difx:=maxx-minx+1;
  dify:=maxy-miny+1;
{  ggg2:=-_hiddenpageoffs+_visiblepageoffs;
  if ggg2<0 then ggg2:=ggg2+(65536);
  ggg:=word(ggg2);}

  asm
    cld
    mov ax,$A000
    mov es,ax
{    mov ax,ggg;
    mov es,ax}
    mov ax,_hiddenpageoffs
    add ax,stx
    mov di,ax                           {es:di = first pixel on screen }

    mov ax,stxh
    add ax,word(sprite)
    mov si,ax                           {si = offset of first array point}


    mov cx,dify
    MOV DX,DIFX
    PUSH DS
    MOV AX,WORD(SPRITE+2)
    MOV DS,AX
    MOV BX,W
    SUB BX,DX

_DrawLoop:
    MOV AH,CL
    mov cx,DX

_lineloop:
    mov al,byte ptr[si]                 {al = pixel to be drawn}
    TEST AL,$FF
    jnz _store

_nopaint:
    inc si
    inc di
    loop _lineloop
    jmp _nextline

_store:
{    mov ax,word(sprite+2)
    mov bx,ds
    mov ds,ax}
    {movsb}
{    mov al,byte ptr[si]
    mov ds,bx
    mov [es:di],al
    jmp _nopaint}

{    movsb}

{    push bx
    mov bl,[es:di]
    shr al,3
    and al,$03
    add al,bl


    pop bx}

{    push es
    push ax
    push di

    mov ax,es
    add ax,di
    mov di,ax

    mov ax,$A000
    mov es,ax
    mov ax,[es:di]
    or ax,$01
    and ax,127
    pop di
    MOV [ES:DI],al
    pop ax
    pop es}
{    push bx
    mov bx,di
    or al,bl
    pop bx}
{    and al,31 {15}
{    or al,80}
    sub al,64
    stosb

    INC SI
{    INC DI}
    loop _lineloop

_nextline:
    MOV CL,AH

    add di,80                           {increment screen pointer by 1 line}
    SUB DI,DX
    add si,BX                            {increment array pointer by 1 width}
    loop _drawloop
    POP DS
  end;
end;




procedure fmove(fa,ta:pointer;len:word); assembler;
  asm
    mov ax,ds
    cld

    mov si,word ptr[fa]
    mov di,word ptr[ta]
    mov es,word ptr[ta+2]
    mov bx,word ptr[fa+2]
    mov cx,word ptr[len]
    mov ds,bx
    rep movsw
    mov ds,ax
end;



procedure laterdodraw(sprite:vvp;offs:word;w,h:integer;x,y,k:integer;invs:boolean);
begin
  with spritestack[k,spritestacktop] do
    begin
      zsprite := sprite;
      zoffs := offs;
      zw := w;
      zh := h;
      zx := x;
      zy := y;
      zinvs:=invs;
      score := isthisscore;
    end;
end;

procedure laterdoMIS(sprite:vvp;offs:word;w,h:integer;x,y,k:integer;invs:boolean);
begin
  with MISstack[k,MISstacktop] do
    begin
      zsprite := sprite;
      zoffs := offs;
      zw := w;
      zh := h;
      zx := x;
      zy := y;
      zinvs :=invs;
    end;
end;

procedure laterdoMIS2(sprite:vvp;offs:word;w,h:integer;x,y,k:integer;invs:boolean);
begin
  with MISstack2[k,MISstacktop2] do
    begin
      zsprite := sprite;
      zoffs := offs;
      zw := w;
      zh := h;
      zx := x;
      zy := y;
      zinvs :=invs;
    end;
end;



procedure copyMISmap(sprite:vvp;x,y:integer;invs : boolean);
var i,k:integer;
    j:integer;
    pt : pointer;
begin
  if MISStacktop=maxmis then exit;
  if ((x<-10) or (x>320)) or ((y<-13) or (y>270)) then exit;
  inc(MISstacktop);

  j:=3;
  for i:=0 to j do
    begin
      k:=((x+i) and 3);
      laterdoMIS(sprite,(i*(sprite^[0]*sprite^[1]))+2,sprite^[0],sprite^[1],(X+i) div 4,Y,k,invs);
    end;
{  copybitmap(sprite,x,y,invs);}
end;

procedure copyMISmap2(sprite:vvp;x,y:integer;invs : boolean);
var i,k:integer;
    j:integer;
    pt : pointer;
begin
  if MISStacktop2=maxmis then exit;
  if ((x<-10) or (x>320)) or ((y<-13) or (y>270)) then exit;
  inc(MISstacktop2);

  j:=3;
  for i:=0 to j do
    begin
      k:=((x+i) and 3);
      laterdoMIS2(sprite,(i*(sprite^[0]*sprite^[1]))+2,sprite^[0],sprite^[1],(X+i) div 4,Y,k,invs);
    end;
{  copybitmap(sprite,x,y,invs);}
end;




procedure copybitmap(sprite:vvp;x,y:integer;invs : boolean);
var i,k:integer;
    j:integer;
    pt : pointer;
begin
{  IF NOT(INVS) THEN
    BEGIN
      COPYMISMAP(SPRITE,X,Y,INVS);
      EXIT;
    END;}
  if spritestacktop=maxmis then exit;
  if ((x<-100) or (x>420)) or ((y<-100) or (y>340)) then exit;
  inc(spritestacktop);

  j:=3;
  for i:=0 to j do
    begin
      k:=((x+i+16) and 3);
{      if zsprite<>sprite[1].shape then}
      laterdodraw(sprite,(word(i)*(word(sprite^[0])*word(sprite^[1])))+2,sprite^[0],sprite^[1],
                (X+160+i) div 4-40,Y,k,invs);
    end;
end;

procedure addscores;
var i,j,k : integer;
    tt  : string;
begin
  if score>999 then score:=0;
  i:=score div 100;
  j:=(score-(i*100)) div 10;
  k:=(score-(i*100)-(j*10));
  copybitmap(sprite[i+26].shape,5,22,true);
  copybitmap(sprite[j+26].shape,10,22,true);
  copybitmap(sprite[k+26].shape,15,22,true);
end;




PROCEDURE MISDRAW;
VAR K:INTEGER;
BEGIN
  PORTW[$3C4]:=$0F02;
  FOR K:=0 TO MISSTACKTOP DO
    WITH MISSTACK[0,K] DO
      if zinvs then
      DODRAW(ZSPRITE,ZOFFS,ZW,ZH,ZX,ZY)
      else
      dopurp(zsprite,zoffs,zw,zh,zx,zy);
  MISSTACKTOP:=-1;
END;

PROCEDURE MISDRAW2;
VAR K:INTEGER;
BEGIN
{  PORTW[$3C4]:=$0F02;}
  FOR K:=0 TO MISSTACKTOP2 DO
    WITH MISSTACK2[0,K] DO
      if zinvs then
      DODRAW2(ZSPRITE,ZOFFS,ZW,ZH,ZX,ZY)
      else
      dopurp(zsprite,zoffs,zw,zh,zx,zy);
  MISSTACKTOP2:=-1;
END;

procedure drawstars(zzz:integer);
var x,y,i,j,k:integer;
    ll:longint;
    ptt,ptt2 : pointer;
    ww  : word;
    ssg,sof,dsg,dof:word;
begin
  ll:=(((((trunc(xxxpos)+10000) div 2)+zzz) div 4)-1250);
  while ll<0 do inc(ll,70);
  while ll>69 do dec(ll,70);

  x:=ll;

  ll:=(round(yyypos) div 2);
  while ll<0 do inc(ll,100);
  while ll>100 do dec(ll,100);
  y:=ll;
  ww:=_hiddenpageoffs+_leftclip+80*_topclip+80;
  ssg:=sgg1;  {seg(star_screen^[zzz,y,x]);}
  sof:=off1+(y*143)+x; {ofs(star_screen^[zzz,y,x]);}
  dsg:=sega000;
  dof:={ofs(virtual_page[virtualnumber]^)}ww;

  ww:=off1; {ofs(star_screen^[zzz,0,0]);}


  for i:=_topclip to _bottomclip-1 do
    begin
    {  ptt:=ptr(sega000,ww);
      ptt2:=addr(star_screen^[zzz,y,x]);
      fmove(ptt2,ptt,36);
      inc(ww,80);
      inc(y,1);
      if y>100 then dec(y,100);}
      fmoves(ssg,sof,dsg,dof);

      inc(sof,143);
      if sof>ww+(x+(143*100)) then dec(sof,(143*100));
      inc(dof,80);

    end;
end;






procedure spritedraw;
var i,j,k:integer;
    ll:longint;
    kkk : integer;
begin
{  if slowmachine then
    begin
      PORTW[$3C4]:=$0F02;
    end;}
  kkk:=_leftclip;
  while xxxpos<0 do xxxpos:=xxxpos+(70*8);
  j:=3;
  if slowmachine then j:=0;
  for i:=0 to j do
    begin
      if not(slowmachine) then
        begin
          port[$3C4]:=$02;
          port[$3C5]:=$01 shl (i);

          port[grac]:=$04;
          port[grac+1]:=(i+1) and 3;

          if dostarsq then
          begin
            if i=3-(trunc(xxxpos/2) and 3) then drawstars(0);
{            if i=3-(trunc(xxxpos/2+1) and 3) then drawstars(1);
            if i=3-(trunc(xxxpos/2+2) and 3) then drawstars(2);
            if i=3-(trunc(xxxpos/2+3) and 3) then drawstars(3);}
          end;
        end;
      for k:=spritestacktop downto 0 do
       begin
         if spritestack[i,k].score=true then
         with spritestack[i,k] do
         dodrawnoclip(zsprite,zoffs,zw,zh,zx,zy)
         else

         with spritestack[i,k] do
           if zinvs then
           dodraw(zsprite,zoffs,zw,zh,zx,zy)
           else
           doinvs(zsprite,zoffs,zw,zh,zx,zy);
       end;



{      _leftclip:=kkk;}

    end;
  MISDRAW;
  MISDRAW2;
  spritestacktop:=-1;
end;

PROCEDURE FLIP;
var w : word;
BEGIN
  spritedraw;


  if botherwithscore or doonemoretime then
  begin
    isthisscore:=true;
    if osc<>score then begin addscores; doonemoretime:=true; end
      else if doonemoretime then begin addscores; doonemoretime:=false; end;
    isthisscore:=false;
    osc:=score;
  end;

  {_WAITINGPAGEOFFS:=_HIDDENPAGEOFFS;
  _HIDDENPAGEOFFS:=_NONACTIVEPAGEOFFS;}

  {  ********** SHOULD BE TIMER ROUTINE }

{  _NONACTIVEPAGEOFFS:=_VISIBLEPAGEOFFS;}

{  SETVISIBLESTART(_WAITINGPAGEOFFS);}
  w:=_hiddenpageoffs;
  _hiddenpageoffs:=_visiblepageoffs;
  setvisiblestart(w);


END;


procedure nodrawflip;
begin
  spritestacktop:=-1;
  misstacktop:=-1;
  misstacktop2:=-1;
  isthisscore:=true;
  if osc<>score then begin addscores; doonemoretime:=true; end
    else if doonemoretime then begin addscores; doonemoretime:=false; end;
  isthisscore:=false;
  osc:=score;
end;

{  if ((x<0) or (x>320)) or ((y<0) or (y>240)) then exit;
  j:=3;
  if slowmachine then j:=0;
  for i:=0 to j do
    begin
    if not(slowmachine) then
     begin
      port[$3C4]:=$02;
      port[$3C5]:=$01 shl ((X+i) and 3);
     end;
      dodraw(sprite,(i*(sprite^[0]*sprite^[1]))+2,sprite^[0],sprite^[1],(X+i) div 4,Y);
    end;}



BEGIN
  spritestacktop:=-1;
  MISSTACKTOP:=-1;
  misstacktop2:=-1;
END.