{$R-}
{$Q-}
{$S-}
{$E-}
{   $M 2048,0,300000}

program SpriteCastle;
Uses Crt,dos,joystick,svga,xvga6,KEYBRD;



const
  obp2 : boolean = false;
  topshot : integer =2;
  changeover: boolean = false;
  countshots : integer =0;

  accr = {16}300;
  redback : integer =0;
  blueback : integer =0;
  greenback : integer =0;
  doslowcheck:boolean=false;
  GG2 : INTEGER = 1;
  slow2: boolean=false;
  maxenemy: integer =25;


type



     ShotSpriteType = record                    { Misc. sprite data            }
                 x, y : integer;         { - current location           }
                 Active : boolean;       { - currently active           }
                 ix, iy : integer;       { - sprite increment           }
                                         {   (not currently used)       }
               end;

     ptype = array[0..255] of
           record
              rn,gn,bn : byte;
           end;
     rotshiptype = array[0..758] of byte;
     rotship = ^rotshiptype;
     rotpnt = ^rotnode;
     rotnode = record
                 next : rotpnt;
                 prev : rotpnt;
                 ang : real;
                 data : rotship;
               end;
     shiptype = record
                  xpos,ypos: real;
                  rot : real;
                  rotd : real;
                  xvel,yvel : real;
                  shp : rotpnt;
                  ang : real;
                end;
     curarray = array[0..31] of integer;
     movbuftype = array[1..4480] of byte;
     mar = array[1..6] of boolean;
     screenobjecttype = record
                          spnum : byte;
                          x  : integer;
                          y  : integer;
                          active : boolean;
                          solar : boolean;
                        end;
     enemytype = record
               x,y  : real;
               rot  : real;
               rotd : real;
               xvel,yvel : real;
               shp : rotpnt;
               ang : real;
               strategy : integer;
               recharge : integer;
               leader : boolean;
               follow : integer;
               dbother,active : boolean;
               damage : integer;
               numfol : integer;
               wayoff : boolean;
               invisible : boolean;
               scox,scoy,scx,scy : integer;
                 end;


const
     ssnums     : integer = 0;
     shottype   : integer = 0;
     maxonscreen : integer = 10;
     totaldamage : integer = 0;
     partdamage  : integer = 0;
     invuln     : integer = 20;

     shotlevel : integer = 5;{7}
     numshot : integer = 1;
     blobyes : boolean = false;
     centerexists : boolean = false;
     timeinc = 1;
     shotcount : boolean=false;
     hit       : boolean=false;
     cnn=20;
     MS4 = 239;
     circl = 52;
     dor : integer =1;
     xmaxshot = 50;
     toggle : boolean=true;                    {toggle the sound here}
     joyinstalled : boolean=true;
     dum1=43*4+4;
     dum2=126;
     maxix=dum1*2;
     maxiy=dum2*2;
     scrposx : integer = 00;
     scrposy : integer = 00;
     oscrposdx : integer = 00;
     oscrposdy : integer = 00;
     qpi = 3.14159/4;
     ic = 3.14159/32;
     checkslow : integer = 0;
     offsset : real =0;
     Diamchange : integer =0;
     brr = 7;
     centerdamage : integer = 10;
     cycles : integer = 0;
type

     missltype =
             record
               hurt      : boolean;
               active    : boolean;
               x,y       : real;
               strategy  : integer;
               xvel,yvel : real;
               atx,aty   : integer;
               arg1,arg2 : real;
               spnum     : byte;
               dormant   : boolean;
               vuln      : boolean;
               omx,omy   : integer;
               omap      : boolean;
             end;
     misshapetype = array[0..121] of byte;
     misshapep = ^misshapetype;
     pointtype = record
                   x,y : integer;
                 end;


var
     quasarstart : boolean;
     closex,closey,closed : integer;
     shotmap    : array [0..32,0..16] of byte;
     mismap     : array [0..32,0..16] of byte;

     oldtimerhandler : pointer;
     enemysonthislevel : integer;
     menleft : integer;
     offsrot : word;
     segrot : word;

     misshape : array[0..2] of misshapep;
     enemy : array[0..200] of enemytype;
     scrobj : array[0..3] of screenobjecttype;
     health : integer;
     dontbother : boolean;
     cshot : record
             xpos,ypos : integer;
             drot : real;
             litx,lity:integer;
             xvelc,yvelc : integer;
          end;
     lasers : integer;

     maxshot : integer;
     shield : array [0..26] of byte;

      missls: array[0..50] of
             missltype;



     mis : mar;
     xsc,ysc : integer;
     inside,lostgame : boolean;
     color : byte;
     movbuf : ^movbuftype;
     pp : pointer;
     changedpal : boolean;
     st : string;
     timereal   : integer;

     int1csave : pointer;
     centjy,centjx : integer;
     sintab : array[0..628] of real;
     dum3 : integer;
     thet : real;
     d1,d2,d3,d4:integer;
     q1,q2,r1: real;
     diam,xdiam: integer;
     w1,w2,w3,w4:integer;
     v1,v2,v3,v4:integer;
     ship : array[1..13] of shiptype;
     pal,pal2,blank,white,redp: ptype;
     shapes1,shapes2,cshape : ^rotnode;
     shottime : integer;
     shotsprite : array [1..xmaxshot] of shotspritetype;
     shot : array[1..xmaxshot] of record
                            xpos : real;
                            ypos : real;
                            dx  : real;
                            dy  : real;
                            tone : integer;
                            ang : real;
                        end;
{     act : array[1..maxsprites] of boolean;}
     soundbuf : record
              info  : array[0..99] of word;
              index : byte;
            end;

{procedure _movefast(fa,ta:pointer;length:word); external;}
function fsin(fr:real):real;
begin
  fr:=trunc(fr*100);
  while fr>628 do fr:=fr-628;
  while fr<0 do fr:=fr+628;
  fsin:=sintab[TRUNC(fr)];
end;

function fcos(fr:real):real;
begin
  fcos:=fsin(1.5707963-fr);
end;




procedure clearpagestarwhite;
VAR PP:^BYTE;
  i:integer;
  j,k,l : word;
label looper,looper2;
BEGIN

  PORTW[$3C4]:=$0F02;
  j:=_hiddenpageoffs+_leftclip+(_topclip*80)+80-2;
  {k:=(_rightclip-_leftclip) div 2 div 3 div 2;
  l:=80-k;}

  asm       { do 73 byte move }
   cld
   mov di,j
   mov bx,_bottomclip
   sub bx,_topclip

   mov ax,$A000
   mov es,ax
   mov ax,68+256*67

looper:

   mov cx,36
   rep stosw
   stosb
   add di,7
   dec bx
   jnz looper


  end;
end;

procedure checkclose(shx,shy:integer);
var i,j,k : integer;
    rx,ry : real;
    os : real;
    b1,b2 : boolean;
    r1,r2,r3:real;
begin
  if shottype<>1 then exit;
  shx:=shx-dum1;
  shy:=shy-dum2;
  if abs(shx)+abs(shy)>=closed then exit;




  os:=2*ship[1].ang*3.14159/64;

  ry:=-fcos(os);
  rx:=fsin(os);

{  r1:=shx*fcos(os)+shy*fsin(os);              }
  r3:=shx*fcos(os+(pi/2))+shy*fsin(os+(pi/2));
{  b1:=r1>0;}
  b2:=r3<0;

  if b2 then
    begin
      closed:=abs(shx)+abs(shy);
      closex:=shx+dum1;
      closey:=shy+dum2;
    end;
end;

  {dbother:=not(b1);
  if b2 then begin
                               rot:=rot-1;
                               shp:=shp^.prev;
                               ang:=ang+((2*pi)/64);
                           end
                else
                           begin
                               rot:=rot+1;
                               shp:=shp^.next;
                               ang:=ang-((2*pi)/64);
                           end;}

{$L clearpag.obj}
procedure _set9; far; external;

procedure clearpagestar;
VAR PP:^BYTE;
  i:integer;
  j,k,l : word;
label looper,looper2;
BEGIN
  PORTW[$3C4]:=$0F02;
  j:=_hiddenpageoffs+_leftclip+(_topclip*80)+80;
  {k:=(_rightclip-_leftclip) div 2 div 3 div 2;
  l:=80-k;}

  asm       { do 73 byte move }
   cld
   mov di,j
   mov bx,_bottomclip
   sub bx,_topclip

   mov ax,$A000
   mov es,ax
   mov ax,0
  { db $98}
{  db $66
  sal ax,1
  mov dx,0}

{  dw $66b8
  dw $0000
  dw $0000}

looper:

{   mov cx,34
   rep stosw}
   mov cx,17

{   db $66
   mov ax,0
   db $00}


{   db $66                       { must find out how to move 0 into eax}
{   rep}
   {db $66
   rep stosw

   stosb}

   call _set9

   add di,11
   dec bx
   jnz looper


  end;




{  asm
    mov ax,_bottomclip
    sub ax,_topclip
    mov cx,sega000
    mov es,cx
    mov di,j

looper:
    push di
    mov cx,k

looper2:
    mov word ptr [es:di],0
    add di,2
    mov word ptr [es:di],0
    add di,2
    mov word ptr [es:di],0
    add di,2

    mov word ptr [es:di],0
    add di,2
    mov word ptr [es:di],0
    add di,2
    mov word ptr [es:di],0
    add di,2

    loop looper2
    mov byte ptr [es:di],0
    pop di
    add di,80
    sub ax,1
    jnz looper
    end;}

END;

PROCEDURE SPPIX_X(X,Y:INTEGER;COLOR : BYTE);
BEGIN
{  PORT[$3C4]:=$02;
  PORT[$3C5]:=$01 SHL (X AND 3);
  MEM[SEGA000:(_SCRNPHYSICALBYTEWIDTH*Y)+(X DIV 4)+_HIDDENPAGEOFFS]:=COLOR;
  MEM[SEGA000:(_SCRNPHYSICALBYTEWIDTH*Y)+(X DIV 4)+_VISIBLEPAGEOFFS]:=COLOR;
  MEM[SEGA000:(_SCRNPHYSICALBYTEWIDTH*Y)+(X DIV 4)+_NONACTIVEPAGEOFFS]:=COLOR;}
END;



procedure winscreen; forward;
{procedure fmove(fa,ta:pointer;len:word); assembler;
  asm
    mov ax,ds
    cld

    mov si,word ptr[fa]
    mov di,word ptr[ta]
    mov es,word ptr[ta+2]
    mov bx,word ptr[fa+2]
    mov cx,word ptr[len]
    mov ds,bx
    rep movsw
    mov ds,ax
end;}

procedure nextguy; forward;

procedure losgame(rx1,ry1,dx1,dy1:real); forward;

function checkinside(i,j:integer):boolean;
begin
  if ((i>0) and (i<319)) and
     ((j>0) and (j<239)) then checkinside:=true
     else checkinside:=false;
end;

function checkin2(i,j:integer):boolean;
begin
  if ((i>18) and (i<300)) and
     ((j>14) and (j<240)) then checkin2:=true
     else checkin2:=false;
end;

{function brr : byte;
begin
  brr:=((color div 16)*16)+7;
end;}


procedure moveto(i,j:integer);
begin
  xsc:=i+trunc(ship[1].xpos);
  ysc:=j+trunc(ship[1].ypos);
  inside:=checkinside(xsc,ysc);
  if inside then ppix_x(xsc,ysc,brr);
end;

procedure setcolor(i:byte);
begin
  color:=i;
end;


procedure clearmissiles;
var i:integer;
begin
  for i:=0 to 50 do
   begin
     missls[i].active:=false;
     missls[i].dormant:=false;
     missls[i].omx:=4;
     missls[i].omy:=4;
     missls[i].omap:=false;
   end;
  fillchar(mismap[0,0],33*17,0);
end;

procedure stuffbuf(inn,pitch:word);
var t,i:word;
begin
  t:=0;
  i:=(soundbuf.index+(inn{*10})) mod 100;
{  while (soundbuf.info[i]>0) and (t<5) do
    begin
      inc(i);
      inc(t);
      if i=100 then i:=0;
    end;}
  for t:=0 to 0 do
    begin
      inc(i);
      if i=100 then i:=0;
      inc(soundbuf.info[i],pitch*5);
    end;
end;

function srpix_x(x,y:integer):byte;
var i,j,shotx,shoty :integer;
    k : byte;
    shxz,shyz : integer;
begin

  k:=0;
{  for i:=2 to maxshot do
    if shotsprite[i].active then
    begin
      j:=trunc(abs(shotsprite[i].x-x)+abs(shotsprite[i].y-y));
      if j<15 then
        begin
          if k=0 then shotsprite[i].active:=false;
          k:=255;

        end;

    end;}

  shotx:=(x-(_leftclip*4)) div 9;
  shoty:=(y-_topclip) div 14;
  if shotx<1 then shotx:=1 else
  if shotx>31 then shotx:=31;
  if shoty<1 then shoty:=1 else
  if shoty>15 then shoty:=15;
  if shotmap[shotx,shoty]+shotmap[shotx+1,shoty]+shotmap[shotx-1,shoty]+
     shotmap[shotx,shoty-1]+shotmap[shotx,shoty+1]>0 then k:=255;
{  shotmap[shotx,shoty]:=255;}




  srpix_x:=k;

end;


function definenewmissile(x,y:real;strategy:integer;xvel,yvel:real;
                         atx,aty:integer;arg1,arg2:real;spnum:byte):integer;
var i,j,k:integer;
begin
  if strategy=6 then
   begin
     if redback<50 then redback:=redback+2;
   end;

  i:=0;
  while (i<51) and (missls[i].active) do inc(i);
  if i=51 then
    begin
      i:=0;
      while (i<51) and (not(missls[i].dormant)) do inc(i);
      if i=51 then
           begin
             definenewmissile:=i;
             exit;
           end;
    end;

  if random(2)=0 then
  begin
  case spnum of
    2 : spnum:=18;
    7..9 : spnum:=spnum+12;
    end;
  end;
  if spnum=10 then spnum:=18;

{  if xvel>8 then xvel:=8
  else if xvel<-8 then xvel:=-8;
  if yvel>8 then yvel:=8
  else if yvel<-8 then yvel:=-8;}
  missls[i].hurt:=not(strategy=6);
  missls[i].x:=x;
  missls[i].y:=y;
  missls[i].strategy:=strategy;
  missls[i].xvel:=xvel;
  missls[i].yvel:=yvel;
  missls[i].atx:=atx;
  missls[i].aty:=aty;
  missls[i].arg1:=arg1;
  missls[i].arg2:=arg2;
  missls[i].spnum:=spnum;
  missls[i].active:=true;
  missls[i].dormant:=false;
  missls[i].vuln:=false;
  definenewmissile:=i;
  stuffbuf(1,30);
end;

procedure spp(w1,w2:word;b:byte);
begin
  mem[sega000:_hiddenpageoffs+w1+w2*80]:=b;
  mem[sega000:_visiblepageoffs+w1+w2*80]:=b;
{  mem[sega000:_nonactivepageoffs+w1+w2*80]:=b;}
end;

procedure addmis(i,j:integer);
var b1,b2 : integer;
    r1,r2,r3,r4 : real;
begin
  r2:=(160-i);
  r3:=(100-j);

  case 1{random(2)} of
    0  :  definenewmissile(i-ship[1].xpos,j-ship[1].ypos,4,
          {xvel}           (i-ship[1].xpos),(j-ship[1].ypos),
          {atx}            0,0,160,1,4);
    1  :  definenewmissile(i-ship[1].xpos,j-ship[1].ypos,5,
          {xvel}           (i-ship[1].xpos),(j-ship[1].ypos),
          {atx}            0,0,10,1,4);
    end;
end;



procedure updateshotlevel;
var i,j,k : integer;
   pp,pp2 :pointer;
begin
   i:=((shottime*29) div (shotlevel*15));


   for k:=3 to 6 do
     if i>=0 then
       begin
         pp:=ptr(sega000,_hiddenpageoffs+(80*k)+1);
         pp2:=ptr(sega000,_hiddenpageoffs+(80*k)+1+i);
         if i>0 then fillchar(pp^,i,255);
         if (29-i)>0 then fillchar(pp2^,(29-i),244);

         pp:=ptr(sega000,_visiblepageoffs+(80*k)+1);
         pp2:=ptr(sega000,_visiblepageoffs+(80*k)+1+i);
         if i>0 then fillchar(pp^,i,255);
         if (29-i)>0 then fillchar(pp2^,(29-i),244);

{         pp:=ptr(sega000,_nonactivepageoffs+(80*k)+1);}
{         pp2:=ptr(sega000,_nonactivepageoffs+(80*k)+1+i);
         if i>0 then fillchar(pp^,i,255);
         if (29-i)>0 then fillchar(pp2^,(29-i),244);}
       end;

end;





procedure set_sintab;
var i : integer;
begin
 for i:=0 to 628 do
    sintab[i]:=sin(i/100);
end;

procedure updatescreen;
var i,j,k : integer;
   pp,pp2 :pointer;
begin
   i:=((health*29) div 10);


   for k:=9 to 12 do
     if i>=0 then
       begin
         pp:=ptr(sega000,_hiddenpageoffs+(80*k)+1);
         pp2:=ptr(sega000,_hiddenpageoffs+(80*k)+1+i);
         if i>0 then fillchar(pp^,i,51);
         if (29-i)>0 then fillchar(pp2^,(29-i),21);

         pp:=ptr(sega000,_visiblepageoffs+(80*k)+1);
         pp2:=ptr(sega000,_visiblepageoffs+(80*k)+1+i);
         if i>0 then fillchar(pp^,i,51);
         if (29-i)>0 then fillchar(pp2^,(29-i),21);

{         pp:=ptr(sega000,_nonactivepageoffs+(80*k)+1);
         pp2:=ptr(sega000,_nonactivepageoffs+(80*k)+1+i);
         if i>0 then fillchar(pp^,i,51);
         if (29-i)>0 then fillchar(pp2^,(29-i),21);}
       end;

{  for j:=4 to 8 do
    begin
     for i:=1+(1 div 4) to (78 div 4)-1 do
        if i*4<=(health shl 3) then spp(i+(10 div 4),j,61) else spp((i+(10 div 4)),j,25);
     if 79<=(health shl 3) then spp((79+10) div 4-1,j,15) else spp((79+10) div 4-1,j,30);
    end;}

end;

procedure loadfailed;
var i,j : integer;
    k : byte;
    BFILE : FILE OF BYTE;
    dfile : file;
    dumptr,ptr2,ptr3 : pointer;                   w1,w2 : word;

begin
  assign(dfile,'screen2.sp4');
  reset(dfile,(80*240));
  dumptr:=ptr(SEGA000,_hiddenpageoffs);

  PORT[$3C4]:=$02;
  PORT[$3C5]:=$01 SHL (0 AND 3);
  blockread(dfile,dumptr^,1);

  PORT[$3C4]:=$02;
  PORT[$3C5]:=$01 SHL (1 AND 3);
  blockread(dfile,dumptr^,1);

  PORT[$3C4]:=$02;
  PORT[$3C5]:=$01 SHL (2 AND 3);
  blockread(dfile,dumptr^,1);

  PORT[$3C4]:=$02;
  PORT[$3C5]:=$01 SHL (3 AND 3);
  blockread(dfile,dumptr^,1);
  close(dfile);
end;


procedure flickinfailed;
var w1 : word;

begin
  w1:=_visiblepageoffs;
  setvisiblestart(_hiddenpageoffs);
  _hiddenpageoffs:=w1;



end;




procedure makescreen;
var i,j : integer;
    k : byte;
    BFILE : FILE OF BYTE;
    dfile : file;
    dumptr,ptr2,ptr3 : pointer;
    w1,w2 : word;
{  procedure rppix_x(x,y,t:integer);
    begin
      if srpix_x(x,y)=0 then
        sppix_x(x,y,t);
    end;}

begin
  assign(dfile,'screen1.sp4');
  reset(dfile,(80*240));
  dumptr:=ptr(SEGA000,_hiddenpageoffs);

  PORT[$3C4]:=$02;
  PORT[$3C5]:=$01 SHL (0 AND 3);
  blockread(dfile,dumptr^,1);

  PORT[$3C4]:=$02;
  PORT[$3C5]:=$01 SHL (1 AND 3);
  blockread(dfile,dumptr^,1);

  PORT[$3C4]:=$02;
  PORT[$3C5]:=$01 SHL (2 AND 3);
  blockread(dfile,dumptr^,1);

  PORT[$3C4]:=$02;
  PORT[$3C5]:=$01 SHL (3 AND 3);
  blockread(dfile,dumptr^,1);

  close(dfile);

  for i:=0 to 3 do
  begin
     port[$3CE]:=$04;
     port[$3CE+1]:=i and 3;



     PORT[$3C4]:=$02;
     PORT[$3C5]:=$01 SHL (i AND 3);


     ptr2:=ptr(sega000,_visiblepageoffs);
     ptr3:=ptr(sega000,_nonactivepageoffs);        move(dumptr^,ptr2^,(80*240));
     move(dumptr^,ptr3^,(80*240));
  end;

  PORTW[$3C4]:=$0F02;
  i:=totaldamage;
  if totaldamage=0 then totaldamage:=100;
  winscreen;
  totaldamage:=i;
  clearpagestar;
  w1:=_hiddenpageoffs;
  _hiddenpageoffs:=_visiblepageoffs;
  _visiblepageoffs:=w1;
  setvisiblestart(w1);
  clearpagestar;

end;

procedure copytovis;
var i : integer;
   dumptr,ptr2: pointer;
begin
  dumptr:=ptr(sega000,_hiddenpageoffs);

    for i:=0 to 3 do
  begin
     port[$3CE]:=$04;
     port[$3CE+1]:=i and 3;



     PORT[$3C4]:=$02;
     PORT[$3C5]:=$01 SHL (i AND 3);


     ptr2:=ptr(sega000,_visiblepageoffs);

     move(dumptr^,ptr2^,(80*240));
  end;
end;

procedure makesnd;

var i:integer;

begin
{  if (soundbuf.info[soundbuf.index]>0) and (toggle) then
                                     sound(soundbuf.info[soundbuf.index])
  else nosound;



  soundbuf.info[soundbuf.index]:=0;
  inc(soundbuf.index);
  if soundbuf.index=100 then soundbuf.index:=0;}



{  if (changeback) then
    begin
      changeback:=false;
      setppl(0,0,0,0);
    end;}


  {begin
   nosound;
    for i:=1 to 5 do
    begin

      if snd[i]=true then
          case i of
             2 : begin
                    setppl(0,random(63),random(63),random(63));
                    sound(trunc(abs(ship.xvel)+abs(ship.yvel))*50);
                    changeback:=true;
                 end;

             3 : begin
                   sound(2000);
                   snd[3]:=false;
                   if offsset<0.5 then offsset:=offsset+0.1;
                 end;
             4 : begin
                  sound(1000);
                  snd[4]:=false;
                 end;
             5 : sound(30+trunc(abs(ship.xvel)+abs(ship.yvel)));

          end;

    end
    end;
   if snd[1] then sound(1500-(abs(dum1-cshot.xpos)+abs(dum2-cshot.ypos)));
   }
end;

procedure uninstalltimerhandler;
begin
  port[$43]:=$34;
  port[$40]:=0;
  port[$40]:=0;
  setintvec(8,oldtimerhandler);
end;


procedure init;
var i:integer;
begin
  quasarstart:=false;
  ssnums:=0;
  closed:=9000;
  fillchar(shotmap[0,0],33*17,0);
  fillchar(mismap[0,0],33*17,0);
  soundbuf.index:=0;
  health:=10;

  SET320X240X256_X;

{  if joyinstalled then initjoystick;}
  set_sintab;
{  nosound;}
  ship[1].xpos:=50;
  ship[1].ypos:=50;
  ship[1].xvel:=0;
  ship[1].yvel:=0;
  SHIP[1].ROT:=0;
  ship[1].rotd:=0;
  clearmissiles;
  cshot.xpos:=-99;
  cshot.litx:=0;
  cshot.lity:=0;

end;




{
procedure rotateshell;


var
   q : integer;
   od1,od2,od3,od4,
   ow1,ow2,ow3,ow4,
   ov1,ov2,ov3,ov4 :integer;

begin
   thet:=thet+(timeinc*dor/15);
   q2:=thet+qpi;
   if thet>-(3.14159+3.14159) then thet:=thet-(3.14159+3.14159);
   if thet<-(3.14159+3.14159) then thet:=thet+(3.14159+3.14159);
   d1:=trunc(FCOS(thet)*diam);
   d2:=trunc(FSIN(thet+offsset)*diam);
   d3:=trunc(FCOS(q2)*diam);
   d4:=trunc(FSIN(q2+offsset)*diam);
   setcolor(circl);
   w1:=(d1*4 div 5);
   w2:=(d2*4 div 5);
   w3:=(d3*4 div 5);
   w4:=(d4*4 div 5);
   v1:=(d1*3 div 5);
   v2:=(d2*3 div 5);
   v3:=(d3*3 div 5);
   v4:=(d4*3 div 5);

   setcolor(shield[0]);
   moveto(0+d1,0+d2);
   lineto(0+d3,0+d4);
   setcolor(shield[1]);
   lineto(0-d2,0+d1);
   IF MIS[1] THEN begin
                    DRAWMIS(xsc,ysc,MS4);
                    if (shield[1]=0) and
                       (shield[2]=0) then begin
                                            mis[1]:=false;
                                            addmis(xsc,ysc);
                                          end;
                  end;

   setcolor(shield[2]);
   lineto(0-d4,0+d3);
   setcolor(shield[3]);
   lineto(0-d1,0-d2);

   setcolor(shield[4]);
   lineto(0-d3,0-d4);
   IF MIS[2] THEN begin
                    DRAWMIS(xsc,ysc,MS4);
                    if (shield[4]=0) and
                       (shield[5]=0) then begin
                                            mis[2]:=false;
                                            addmis(xsc,ysc);
                                          end;
                  end;

   setcolor(shield[5]);
   lineto(0+d2,0-d1);
   setcolor(shield[6]);
   lineto(0+d4,0-d3);
   setcolor(shield[7]);
   lineto(0+d1,0+d2);

   setcolor(shield[8]);
   moveto(0-w1,0+w2);
   lineto(0-w3,0+w4);
   setcolor(shield[9]);
   lineto(0+w2,0+w1);
   setcolor(shield[10]);
   lineto(0+w4,0+w3);
   setcolor(shield[11]);
   lineto(0+w1,0-w2);
   IF MIS[3] THEN begin
                    DRAWMIS(xsc,ysc,MS4);
                    if (shield[11]=0) and
                       (shield[12]=0) then begin
                                            mis[3]:=false;
                                            addmis(xsc,ysc);
                                          end;
                  end;
   setcolor(shield[12]);
   lineto(0+w3,0-w4);
   setcolor(shield[13]);
   lineto(0-w2,0-w1);
   setcolor(shield[14]);
   lineto(0-w4,0-w3);
   setcolor(shield[15]);
   lineto(0-w1,0+w2);
   IF MIS[4] THEN begin
                    DRAWMIS(xsc,ysc,MS4);
                    if (shield[15]=0) and
                       (shield[08]=0) then begin
                                            mis[4]:=false;
                                            addmis(xsc,ysc);
                                          end;
                  end;

   setcolor(shield[16]);
   moveto(0+v1,0+v2);
   lineto(0+v3,0+v4);
   setcolor(shield[17]);
   lineto(0-v2,0+v1);
   setcolor(shield[18]);
   lineto(0-v4,0+v3);
   setcolor(shield[19]);
   lineto(0-v1,0-v2);
   IF MIS[6] THEN begin
                    DRAWMIS(xsc,ysc,MS4);
                    if (shield[19]=0) and
                       (shield[20]=0) then begin
                                            mis[6]:=false;
                                            addmis(xsc,ysc);
                                          end;
                  end;
   setcolor(shield[20]);
   lineto(0-v3,0-v4);
   setcolor(shield[21]);
   lineto(0+v2,0-v1);
   setcolor(shield[22]);
   lineto(0+v4,0-v3);
   IF MIS[5] THEN begin
                    DRAWMIS(xsc,ysc,MS4);
                    if (shield[22]=0) and
                       (shield[23]=0) then begin
                                            mis[5]:=false;
                                            addmis(xsc,ysc);
                                          end;
                  end;
   setcolor(shield[23]);
   lineto(0+v1,0+v2);

end;
 }

procedure SetVGAPalette(PalBuf : ptype);
var
  Reg : Registers;
label wait,retr;

begin
  asm


        MOV     si,0 {(320*200)}
        mov     bx,0


        MOV     DX,3DAh
Wait:   IN      AL,DX
        TEST    AL,08h
        JZ      Wait
Retr:   IN      AL,DX
        TEST    AL,08h
        JNZ     Retr
  end;

  reg.ax := $1012;
  reg.bx := 0;
  reg.cx := 256;
  reg.es := Seg(PalBuf);
  reg.dx := Ofs(PalBuf);
  intr($10,reg);
end;


procedure clear_shotmap;
var i,shotx,shoty:integer;
begin
 {fillchar(shotmap[0,0],33*17,0);}
 for i:=2 to maxshot do
    if (shotsprite[i].active) then
      begin
{        if shot[i].tone>998 then
            copyMISmap(sprite[9].shape,shotsprite[i].x+4,shotsprite[i].y+4,true)
        else if shot[i].tone>995 then
            copyMISmap(sprite[7].shape,shotsprite[i].x+2,shotsprite[i].y+3,true)
        else if shot[i].tone>991 then
           copyMISmap(sprite[8].shape,shotsprite[i].x+2,shotsprite[i].y+3,true)
        else
           copyMISmap(sprite[2].shape,shotsprite[i].x+3,shotsprite[i].y+3,true);}

        shotx:=(shotsprite[i].x+3-(_leftclip*4)) div 9;
        shoty:=(shotsprite[i].y+3-_topclip) div 14;
        if shotx<0 then shotx:=0 else
        if shotx>32 then shotx:=32;
        if shoty<0 then shoty:=0 else
        if shoty>16 then shoty:=16;
        shotmap[shotx,shoty]:=0;
      end;

end;

procedure set_pal(a:byte;r:byte;g:byte;b:byte);
begin
     if r>0 then pal[a].rn:=r else pal[a].rn:=0;
     if g>0 then pal[a].gn:=g else pal[a].gn:=0;
     if b>0 then pal[a].bn:=b else pal[a].bn:=0;

end;

procedure setppl(a:byte;r:byte;g:byte;b:byte);
begin
    set_pal(a,r,g,b);
    setvgapalette(pal);
end;


procedure stand_pal;
var d1,d2,i:integer;
begin
  for i:=0 to 15 do
    begin
      set_pal(i,4*i,4*i,4*i);
      set_pal(i+16,4*i,0,0);
      set_pal(i+32,0,4*i,0);
      set_pal(i+48,0,0,4*i);
      set_pal(i+64,4*i,4*i,0);
      set_pal(i+80,4*i,0,4*i);
      set_pal(i+96,0,4*i,4*i);
      set_pal(i+112,4*i,63,63);
      set_pal(i+128,63,4*i,63);
      set_pal(i+144,63,63,4*i);
      set_pal(i+160,4*i,4*i,63);
      set_pal(i+176,4*i,63,4*i);
      set_pal(i+192,63,4*i,4*i);
      set_pal(i+208,4*i,63,0);
      set_pal(i+224,63,4*i,0);
      set_pal(i+240,4*i,2*i,0);
    end;
  for i:=0 to 255 do
    begin
      blank[i].rn:=2;
      blank[i].gn:=2;
      blank[i].bn:=2;
      white[i].rn:=63;
      white[i].gn:=63;
      white[i].bn:=63;
{      redp[i]:=blank[i];
      redp[i].rn:=(pal[i].rn+pal[i].bn+pal[i].gn) div 3;}
    end;
{  for i:=0 to 43 do

    begin
      set_pal(112+i,random(10),random(10),20+random(14));
    end;}
   for i:=0 to 207 do
   begin
     redp[i]:=pal[i];
   end;
   for d2:=384-120 to 384+119 do
    begin
      d1:=255-((d2-263) div 5);
      redp[d1].rn:=0;
      redp[d1].gn:=((240-(d2-263)) div 11) div 3;
      redp[d1].bn:=((d2-263) div 5) div 3;
    end;


end;

procedure GETROT(var ship : shiptype;name:string);
var dum1:integer;
    op,fp : rotpnt;
    fff : file;
begin
  fp:=new(rotpnt);
  ship.shp:=fp;
  op:=fp;
  assign(fff,name);
  reset(fff,758);
  new(op^.data);
  blockread(fff,op^.data,1);

  for dum1:=1 to 63 do
    begin
      op^.prev:=new(rotpnt);
      op^.prev^.next:=op;
      op:=op^.prev;
      new(op^.data);
      blockread(fff,op^.data,1);
    end;
    fp^.next:=op;
    op^.prev:=fp;
  close(fff);
  ship.ang:=0;
  ship.rot:=0;
end;





procedure correctscreenpos;
var i,j,k,d1,d2 : integer;
    ll : longint;
    ss,se : integer;
    s1,s2 : integer;
    pp : pointer;
    s3 : word;

begin
{  tem_stars:=star_screen;
  j:=_rightclip-_leftclip;
  for i:=0 to 200 do
    begin
      tem_stars[i].x:=tem_stars[i].x+round(ship[1].xpos) div 2;
      tem_stars[i].y:=tem_stars[i].y+round(ship[1].ypos) div 2;
      while tem_stars[i].x<_leftclip*4 do inc(tem_stars[i].x,j*4);
      while tem_stars[i].x>_rightclip*4 do dec(tem_stars[i].x,j*4);
      while tem_stars[i].y<_topclip do inc(tem_stars[i].y,225);
      while tem_stars[i].y>_bottomclip do dec(tem_stars[i].y,225);
    end;
  ppix_x(tem_stars[0].x,tem_stars[0].y,3);
  for i:=1 to 200 do
    with tem_stars[i] do
      MEM[SEGA000:(_SCRNPHYSICALBYTEWIDTH*tem_stars[i].Y)+
      (tem_stars[i].X DIV 4)+_HIDDENPAGEOFFS]:=colorzz[i];



{  ll:=round((-ship[1].xpos)) div 2;
  ll:=ll+(300*(round((-ship[1].ypos)) div 2));

  while ll<=0 do inc(ll,(240*75*4));
  while ll>(240*75*4) do dec(ll,(240*75*4));
  PORT[$3C4]:=$02;
  PORT[$3C5]:=$01 SHL (3-(ll AND 3));}
{  port[$3CE]:=$04;
  port[$3CE+1]:=1}{ll and 3};
{
  ll:=ll div 4;
  s2:=_rightclip-_leftclip+1;
  for s1:=_topclip+1 to _bottomclip-1 do
    begin
      s3:=word(ll)+(75*s1);
{      while s3<1 do inc(s3,(75*102));
      while s3>(75*102) do dec(s3,(75*102));}

{      pp:=ptr(sega000,_hiddenpageoffs+(s1*80)+_leftclip);
      move(star_screen[s3],pp^,s2);
    end;}

{  ll:=ll div 4;
  s2:=ll;
  s1:=((80*240)-ll);
  pp:=ptr(sega000,_hiddenpageoffs);
  move(star_screen^[s1],
        pp^,s2);

  pp:=ptr(sega000,_hiddenpageoffs+s2-1);
  move((star_screen^[1]),
        pp^,s1);}


{  ll:=round((ship[1].xPOS)) div 2;
  ll:=ll+(320*(round((ship[1].yPOS)) div 2));
  while ll<=0 do inc(ll,(320*200));
  while ll>(320*200) do dec(ll,(320*200));
  s2:=(ll);
  s1:=((320*200)-ll);
  fmove(addr(star_screen^[s1]),
        addr(virtual_screen^[1]),s2 div 2);
  fmove(addr(star_screen^[1]),
        addr(virtual_screen^[s2]),s1 div 2);}

end;

procedure setsound(sss:integer); assembler;
asm
  mov al,10110110b
  out 43h,al
  mov ax,sss
  out 42h,al
  mov al,ah
  out 42h,al
end;


procedure timer; interrupt;
begin
  inc(tcountz);
  if tcountz=10 then
    begin
      inc(timeguess);
      tcountz:=0;
    end;

  if toggle then
  begin
  if ((tcountz=0) or (tcountz=5)) and
  ((shottype=1) and (quasarstart)) then  setsound(1200000 div (soundbuf.info[soundbuf.index]+(25*ssnums)+50))
  else
  if (soundbuf.info[soundbuf.index]>0) then
    begin
       setsound(1200000 div (soundbuf.info[soundbuf.index]));
    end

    else setsound(1);
  end;



  soundbuf.info[soundbuf.index]:=0;
  inc(soundbuf.index);
  if soundbuf.index=100 then soundbuf.index:=0;




  port[$20]:=$20;
end;

procedure makestars;
var d1,i,d2,d3:integer;
begin
  for d1:=0 to 99 do soundbuf.info[d1]:=0;
  fillchar(star_screen^,sizeof(star_screen^){4*101*141{-1},0);
{  PORTW[$3c4]:=$0F02;}



{  for d1:=0 to 1000 do
    begin
      star_screen^[random(4),random(101),random(71)]:=96+random(2)+1;
      star_screen^[random(4),random(101),random(71)]:=48+random(2)+1;
      star_screen^[random(4),random(101),random(71)]:=96+random(1)+1;
      star_screen^[random(4),random(101),random(71)]:=96+random(1)+1;
      star_screen^[random(4),random(101),random(71)]:=96+random(1)+1;



    end;
}
  for d1:=0 to 300 div 4 do
    begin
      star_screen^[0,random(101),random(71)]:=96+random(5);
      star_screen^[0,random(101),random(71)]:=48+random(5);
      star_screen^[0,random(101),random(71)]:=96+random(3);
      star_screen^[0,random(101),random(71)]:=96+random(3);
      star_screen^[0,random(101),random(71)]:=96+random(3);



    end;
{  for d2:=0 to 100 do
    for d1:=0 to 69 do
     for i:=0 to 3 do
      star_screen^[i,d2,d1]:=96+round(7-(7*abs(fsin(random(100)))));}

  for d2:=0 to 100 do
  for d1:=70 to 142 do
    for i:=0 to 0 do
      star_screen^[i,d2,d1]:=star_screen^[i,d2,d1-70];


{  move(star_screen,star_screen[(75*240)],75*240-1);}
end;

procedure getinp(var xl,yl:integer);
var t1,t2,tbt:integer;
begin
  buttonpushed[1]:=false;
  buttonpushed[2]:=false;
  xl:=100;
  yl:=100;

  if joyinstalled then
    getjoy(xl,yl);
  if Rightshift_Pressed then yl:=joysticky-joysens*2;
  if Ctrl_Pressed then buttonpushed[1]:=true;
  if Leftshift_pressed then xl:=xl-joysens-joysens;
  if Alt_pressed then xl:=xl+joysens+joysens;
end;

procedure getbuttons;
begin
  buttonpushed[1]:=false;
  buttonpushed[2]:=false;
  if joyinstalled then
    begin
      buttonpushed[1]:=(port[$201] and 16=0);
      buttonpushed[2]:=(port[$201] and 32=0);
    end;
  if Ctrl_Pressed then buttonpushed[1]:=true;
end;


procedure heatup(l:byte);
begin
  if pal[l].bn>5 then dec(pal[l].bn,5);
  if pal[l].rn<40 then inc(pal[l].rn,5);
{  if pal[l].rn<60 then inc(pal[l].rn,20);
  if pal[l].bn<60 then inc(pal[l].bn,10);
  if pal[l].gn<60 then inc(pal[l].gn,10);
  if pal[l].rn>60 then pal[l].rn:=60;
  if pal[l].gn>60 then pal[l].gn:=60;
  if pal[l].bn>60 then pal[l].bn:=60;}
end;

{procedure dodis;
var i:integer;
    r,b,g:integer;
begin
  r:=0;g:=0;b:=0;
  if timereal div 2=timereal/2 then exit;
  for i:=113 to 155 do
    begin
      pal2[i].rn:=(pal[i-1].rn div 2+pal[i].rn div 2);
      pal2[i].gn:=(pal[i-1].gn div 2+pal[i].gn div 2);
      pal2[i].bn:=(pal[i-1].bn div 2+pal[i].bn div 2);
    end;
  pal2[112].rn:=(pal[155].rn div 2+pal[112].rn div 2)-1;
  pal2[112].gn:=(pal[155].gn div 2+pal[112].gn div 2)-1;
  pal2[112].bn:=(pal[155].bn div 2+pal[112].bn div 2)+1;
  if pal2[112].bn>30 then pal2[112].bn:=30;
  for i:=112 to 155 do
    begin
      pal[i]:=pal2[i];
      if pal[i].rn<blank[i].rn then pal[i].rn:=blank[i].rn;
      if pal[i].gn<blank[i].gn then pal[i].gn:=blank[i].gn;
      if pal[i].bn<blank[i].bn then pal[i].bn:=blank[i].bn;

      inc(r,pal[i].rn);
      inc(g,pal[i].gn);
      inc(b,pal[i].bn);
    end;
  r:=r div (44);
  g:=g div (44);
  b:=b div (44);
  set_pal(56,r,g,b);
end;}


procedure setupinp;
var dumchr:char;
    x,y : integer;
    autobut : boolean;
begin
{  textcolor(15);
  textbackground(0);
  clrscr;
  Writeln('Star Castle');
  writeln('By Todd Rudick');
  writeln;
  writeln('Requires: 320x200x256 VGA');
  writeln('          Joystick 1');
  writeln;
  writeln('Press "Q" to quit,');
  writeln('      "I" for instructions,');
  writeln('      or center joystick and press any other key to play...');
  writeln('     OR hit "M" to use mouse instead');}
  testforjoy(autobut);
{  if autobut then testforjoy(autobut);}
  buttonpushed[1]:=false;
  if autobut then
   repeat
     getbuttons;
   until keypressed or buttonpushed[1];
  if buttonpushed[1] then dumchr:='J' else
     dumchr:=upcase(readkey);
  if dumchr='Q' then
     begin
       textmode($03);

       uninstalltimerhandler;

       nosound;


       halt;
     end;
  {if upcase(dumchr)='I' then instructions;}
  joyinstalled:=false;
  if dumchr='J' then
   begin
     TESTFORJOY(joyinstalled);
       IF NOT(JOYINSTALLED) THEN
     TESTFORJOY(JOYINSTALLED);

     if not(joyinstalled) then
       begin
         sound(100);
         delay(500);
         nosound;
       end;
   end;

  joysens:=50;
  joystickx:=100;
  joysticky:=100;
  if joyinstalled then initjoystick;
{  else
  begin
    x:=2;
    y:=2;
    mstatus(y,x);
    if y=0 then
      begin
        halt;
      end;

    mhide;
    joystickx:=100;
    joysticky:=100;
    mhlimit(0,200);
    mvlimit(0,200);
  end;}
  buttonpushed[1]:=false;
  buttonpushed[2]:=false;

end;




procedure hiton(jj:integer);
begin
  if diam=xdiam then
  case shield[jj] of
    4..15    :  dec(shield[jj]);
    3        :  shield[jj]:=31;
    31       :  dec(shield[jj]);
    30           : shield[jj]:=0;
    end;
  hit:=true;
end;



procedure exploscreen;
begin
  centerdamage:=10;
  makescreen;
end;

procedure winscreen;
var i,k,d1,d2,d3,i1,i2 : integer;
    r1,r2 : real;
    pp,pp2:pointer;
const
   lentt = 41;
begin
{  sound(440);
  nosound;
  for d3:=1 to 20 do
              begin
                d1:=trunc(ship[1].xpos)-(sprite[13].h div 2)
                   +random(31)-15;
                d2:=trunc(ship[1].ypos)-(sprite[13].h div 2)
                   +random(31)-15;}
{                if checkinside(d1,d2) then}
{                     csprite(sprite[13],d1,d2)
             end;
  dec(centerdamage,1);
  d3:=160+centerdamage*10;
  for d2:=4 to 8 do
  for d1:=d3 to d3+10 do
    ppix_x(d1,d2,28);
  if centerdamage=0 then exploscreen;}

  d1:=(totaldamage-partdamage);
  d2:=((d1*lentt) div totaldamage);
{  d3:=lentt-d2;}

{  for i1:=4 to 8 do
  begin
    for i2:=(161 div 4) to ((160+d2) div 4) do spp(i2,i1,62);
    for i2:=((161+d2) div 4) to ((161+lentt) div 4) do
                                               spp(i2,i1,28);
  end;}

  i:=d2;
  if (d1>0) and (i=0) then i:=1;


   for k:=9 to 12 do
     if i>=0 then
       begin
         pp:=ptr(sega000,_hiddenpageoffs+(80*k)+38);
         pp2:=ptr(sega000,_hiddenpageoffs+(80*k)+38+i);
         if i>0 then fillchar(pp^,i,21);
         if (41-i)>0 then fillchar(pp2^,(41-i),35);

         pp:=ptr(sega000,_visiblepageoffs+(80*k)+38);
         pp2:=ptr(sega000,_visiblepageoffs+(80*k)+38+i);
         if i>0 then fillchar(pp^,i,21);
         if (41-i)>0 then fillchar(pp2^,(41-i),35);

{         pp:=ptr(sega000,_nonactivepageoffs+(80*k)+38);
         pp2:=ptr(sega000,_nonactivepageoffs+(80*k)+38+i);
         if i>0 then fillchar(pp^,i,21);
         if (41-i)>0 then fillchar(pp2^,(41-i),35);}
       end;




end;



procedure sshots(i:integer);                {borrowed}
var jb1,jb2,temp,temp2,ttt : real;
    xpos,ypos,ddd1,ddd2 : integer;

begin
  xpos:=trunc(shotsprite[i].x);
  ypos:=trunc(shotsprite[i].y);
  ddd1:=trunc(ship[1].xpos);
  ddd2:=trunc(ship[1].ypos);
  if (abs(ypos-ddd2)>xdiam+5) or (abs(xpos-ddd1)>xdiam+5) then exit;

             jb1:=(sqr((xpos/10)-(ddd1/10))+sqr((ypos/10)-(ddd2/10)));
             if (jb1<sqr((xdiam)/8)) and (jb1>0) then
                begin
                   temp:=ddd1-xpos;
                   if temp=0 then temp:=0.1;
                   temp2:=abs(arctan((ddd2-ypos)/temp));
                   if ypos<ddd2 then
                     begin
                       if xpos<ddd1 then temp2:=temp2+3.14159
                       else temp2:=(3.14159+3.14159)-temp2;
                     end
                   else
                    if xpos<ddd1 then temp2:=3.14159-temp2;
                    ttt:=temp2;
                    temp2:=temp2-thet;
                    while temp2>(3.14159+3.14159) do temp2:=temp2-3.14159-3.14159;
                    while temp2<0 do temp2:=temp2+3.14159+3.14159;
                    jb2:=trunc(temp2/(3.14159+3.14159)*8);
                    if shield[trunc(jb2)]>0 then
                      begin
                        hiton(trunc(jb2));
                        shotsprite[i].active:=false;
                      end
             else
                begin
                  temp2:=3.14159-(ttt+thet);
                  while temp2>(3.14159+3.14159) do temp2:=temp2-(3.14159+3.14159);
                  while temp2<0 do temp2:=temp2+(3.14159+3.14159);
                  jb2:=8+trunc(temp2/(3.14159+3.14159)*8);
                  if (jb1<sqr((((xdiam*4) div 5))/8)) and
                                        (shield[trunc(jb2)]>0) then
                     begin
                       hiton(trunc(jb2));
                       shotsprite[i].active:=false;
                     end
                        else
                begin
                  temp2:=ttt-thet;
                  while temp2>(3.14159+3.14159) do temp2:=temp2-3.14159-3.14159;
                  while temp2<0 do temp2:=temp2+3.14159+3.14159;
{ $R-}
                  jb2:=trunc(temp2/(3.14159+3.14159)*8)+16;
                  if (jb1<sqr((((xdiam*3) div 5))/8)) and
                                        (shield[trunc(jb2)]>0) then
{ $R+}
                    begin
                      hiton(trunc(jb2));
                      shotsprite[i].active:=false;
                    end
                  else
                    if (jb1<sqr((((xdiam*2) div 5))/8)) then
                       begin
                          winscreen;
                          shotsprite[i].active:=false;
                       end;
                 end;

end;   {SSHOTS}   {BORROWED!}
end;
end;

function pook:real;
var i:real;
begin
  i:=(random(21));
  i:=i-10;
  pook:=i/100;
end;
procedure update_shots;
var z,i,j,k,l,shx,shy,tttx,ttty,d1,d2,d3 : integer;
    temp,at : real;
    pp : word;
    pz : word;
    shotx,shoty:integer;
begin
  countshots:=0;
  if shottype<>0 then exit;
  clear_shotmap;
  inc(shottime);
  countshots:=0;
  {if not(buttonpushed[1]) then shottime:=10000;}
  if shottime>shotlevel*15 then shottime:=shotlevel*15;
  pz:=word((shottime div shotlevel)+17);
  if pz>31 then pz:=255;
  pz:=pz+pz shl 8;
  pp:=314;
{  while pp<(320*199) do                        *** fix this ***
    begin
      inc(pp,320);
      memw[sega000:pp]:=pz;
      memw[sega000:pp+2]:=pz;
      memw[sega000:pp+4]:=pz;
    end;}



  if ((buttonpushed[1]) and (shottime>(shotlevel))) {and not(cycles and 1=0)} then
{    if (shotcount) then}
for d3:=1 to numshot do
      begin
        k:=-1;
        for i:=maxshot downto 2 do
         if shotsprite[i].active=false then k:=i;
        if k<>-1 then
          begin
{            stuffbuf(1,100+shottime*5);
            stuffbuf(1,100);}
            stuffbuf(1,100-k);
            shotsprite[k].active:=true;
            shot[k].dy:=-fcos((2*ship[1].ang*3.14159/64)+pook)*15;
            shot[k].dx:=fsin((2*ship[1].ang*3.14159/64)+pook)*15;
            shotsprite[k].x:=trunc(sprite[1].x)+8+1*round(shot[k].dx);
            shotsprite[k].y:=trunc(sprite[1].y)+8+1*round(shot[k].dy);
            shot[k].tone:=1000;
            dec(shottime,shotlevel);
{            shottime:=0;}
            {sound(30);}
            ship[1].xvel:=ship[1].xvel+(shot[k].dx/40);
            ship[1].yvel:=ship[1].yvel+(shot[k].dy/40);
            shotsprite[k].x:=shotsprite[k].x+round(shot[k].dy);
            shotsprite[k].y:=shotsprite[k].y-round(shot[k].dx);
            shotcount:=not(shotcount);
          end;
 {      end}
{       else              }
{       begin}

        k:=-1;
        for i:=maxshot downto 2 do
         if shotsprite[i].active=false then k:=i;
        if k<>-1 then
          begin
            shotsprite[k].active:=true;
            shot[k].dy:=-fcos((2*ship[1].ang*3.14159/64)+pook)*15;
            shot[k].dx:=fsin((2*ship[1].ang*3.14159/64)+pook)*15;
            shotsprite[k].x:=trunc(sprite[1].x)+8+1*round(shot[k].dx);
            shotsprite[k].y:=trunc(sprite[1].y)+8+1*round(shot[k].dy);
            shot[k].tone:=1000;
            shotsprite[k].x:=shotsprite[k].x-round(shot[k].dy);
            shotsprite[k].y:=shotsprite[k].y+round(shot[k].dx);
            shotcount:=not(shotcount);
          end;
      end;

  for i:=2 to maxshot do
    if (shotsprite[i].active) then
      begin
        inc(countshots);
        dec(shot[i].tone,1);
        if shot[i].tone<10 then shot[i].tone:=10;

{        stuffbuf(1,shot[i].tone div 120);}

        shotsprite[i].x:=shotsprite[i].x+round(shot[i].dx*timeinc/1.5);
        shotsprite[i].y:=shotsprite[i].y+round(shot[i].dy*timeinc/1.5);
        if ((shotsprite[i].x<0) or (shotsprite[i].x>319)) or
           ((shotsprite[i].y<0) or (shotsprite[i].y>239)) then shotsprite[i].active:=false
        else
          begin
            hit:=false;
            if centerexists then sshots(i);





            if (hit) then
            begin




                if offsset<0.5 then offsset:=offsset+(random(10)/150);
                for d3:=1 to 5 do
             begin
                d1:=((shotsprite[i].x+trunc(ship[1].xpos)) div 2)
                   +random(31)-15;
                d2:=((shotsprite[i].y+trunc(ship[1].ypos)) div 2)
                   +random(31)-15;
{                if checkinside(d1,d2) then}
                     copybitmap(sprite[5+random(2)].shape,d1,d2,true)
             end;
            end;

          end;

      end;
  for i:=2 to maxshot do
    if (shotsprite[i].active) then
      begin
        if shot[i].tone>998 then
            copyMISmap2(sprite[9].shape,shotsprite[i].x+4,shotsprite[i].y+4,true)
        else if shot[i].tone>995 then
            copyMISmap2(sprite[7].shape,shotsprite[i].x+2,shotsprite[i].y+3,true)
        else if shot[i].tone>991 then
           copyMISmap2(sprite[8].shape,shotsprite[i].x+2,shotsprite[i].y+3,true)
        else
           copyMISmap2(sprite[2].shape,shotsprite[i].x+3,shotsprite[i].y+3,true);

        shotx:=(shotsprite[i].x+3-(_leftclip*4)) div 9;
        shoty:=(shotsprite[i].y+3-_topclip) div 14;
        if shotx<0 then shotx:=0 else
        if shotx>32 then shotx:=32;
        if shoty<0 then shoty:=0 else
        if shoty>16 then shoty:=16;
        shotmap[shotx,shoty]:=255;
      end;

  if redback<(countshots div 4) then redback:=(countshots div 4);
  if greenback<(countshots div 6) then greenback:=(countshots div 6);

end;

procedure update_ship;
var jx,jy : integer;
    prtx,prty : real;
    tt        : integer;
    tttx,ttty,shx,shy : integer;
    oxp,oyp : real;
    zzyvel,zzxvel,zzt2,shotx,shoty : integer;
    zzt,zr1,zr2,zr3,zr4 : real;

begin
  getinp(jx,jy);




  if jx<joystickx-joysens then begin
{                            ship[1].rot:=ship[1].rot-(timeinc*2);
                            ship[1].ang:=ship[1].ang-(timeinc*2);}
                            ship[1].rotd:=ship[1].rotd-0.8;
                          end
  else if jx>joystickx+joysens then begin
                            ship[1].rotd:=ship[1].rotd+0.8;
{                            ship[1].rot:=ship[1].rot+(timeinc*2);
                            ship[1].ang:=ship[1].ang+(timeinc*2);}
                          end;

  if ship[1].ang>=64 then ship[1].ang:=ship[1].ang-64;
  if ship[1].ang<0 then ship[1].ang:=ship[1].ang+64;

  if jy<joysticky-joysens then with ship[1] do
                         begin
                           tt:=trunc(ship[1].ang);
                           yvel:=(yvel+(FCOS(2*ang*3.14159/64)*timeinc*1.5));
                           xvel:=(xvel-(FSIN(2*ang*3.14159/64)*timeinc*1.5));
{                           sound(35);}
                           stuffbuf(1,35);
                           stuffbuf(2,25);
                         end;
  with ship[1] do
   begin
     oxp:=xpos;oyp:=ypos;
     xpos:=xpos+xvel;
     ypos:=ypos+yvel;
     if abs(xvel)+abs(yvel)<(timeinc) then
       begin
         xvel:=xvel/2;
         yvel:=yvel/2;
       end;

     if (xvel>timeinc/8) then xvel:=xvel-(timeinc/8)
     else if (xvel<-timeinc/8) then xvel:=xvel+(timeinc/8);

     if yvel>(timeinc/8) then yvel:=yvel-(timeinc/8)
     else if yvel<(-timeinc/8) then yvel:=yvel+(timeinc/8);

     IF XVEL>20 THEN XVEL:=20
     ELSE IF XVEL<-20 THEN XVEL:=-20;
     IF YVEL>20 THEN YVEL:=20
     ELSE IF YVEL<-20 THEN YVEL:=-20;

   end;

  ship[1].rot:=ship[1].rot+ship[1].rotd;
  ship[1].ang:=ship[1].ang+ship[1].rotd;
  ship[1].rotd:=ship[1].rotd/1.5;

  while ship[1].rot>=1 do
    begin
      ship[1].rot:=ship[1].rot-1;
{      ship[1].shp:=ship[1].shp^.prev;}
      ship[2].shp:=ship[2].shp^.prev;
    end;

  while ship[1].rot<=-1 do
    begin
      ship[1].rot:=ship[1].rot+1;
{      ship[1].shp:=ship[1].shp^.next;}
      ship[2].shp:=ship[2].shp^.next;
    end;

  if jy<joysticky-joysens then
    begin
     zzt:=(2*ship[1].ang*3.14159/64){-0.176};
     zzyvel:=-round((FCOS(zzt)*15));
     zzxvel:=round((FSIN(zzt)*15));

     for zzt2:=1 to 3 do
       copyMISmap(sprite[7].shape,dum1-14-2*round(ship[1].xvel)+09-zzxvel+random(7)-3-2,
                dum2-14-2*round(ship[1].yvel)+09-zzyvel+random(7)-3-1,true);
{     copysprite(sprite[7],146-2*round(ship[1].xvel)+9-zzxvel+random(3)-1,
                          86-2*round(ship[1].yvel)+9-zzyvel+random(3)-1);}

     zzyvel:=(zzyvel*7) div 5;
     zzxvel:=(zzxvel*7) div 5;

     for zzt2:=1 to 3 do
     copyMISmap(sprite[9].shape,dum1-14-2*round(ship[1].xvel)+11-zzxvel+random(5)-2-2,
                dum2-14-2*round(ship[1].yvel)+11-zzyvel+random(5)-2-1,true);
    end;

{    move(ship[2].shp^.data,sprite[1].spritedata,(27*27)-1);}

  sprite[1].x:=dum1-14-2*round(ship[1].xvel);
  sprite[1].y:=dum2-14-2*round(ship[1].yvel);
{  sprite[1].active:=true;}

  tttx:=2*round(ship[1].xvel);
  ttty:=2*round(ship[1].yvel);
  shx:=round(-ship[1].xpos+dum1)-tttx;
  shy:=round(-ship[1].ypos+dum2)-ttty;
  pal[0].bn:=0;
  if centerexists then
  if (abs(shx)<100) and (abs(shy)<100) then
      if sqr(shx)+sqr(shy)<3400 then
      with ship[1] do
      begin
{        pal[0].bn:=10;}
{        ship[1].xvel:=-ship[1].xvel/2;
        ship[1].yvel:=-ship[1].yvel/2;
        ship[1].xpos:=oxp;
        ship[1].ypos:=oyp;}

        zr1:=shx;
        zr2:=shy;
        zr3:=sqrt(sqr(shx)+sqr(shy));
        shx:=round((shx/zr3)*sqrt(3400));
        shy:=round((shy/zr3)*sqrt(3400));
        xpos:=xpos-shx+zr1;
        ypos:=ypos-shy+zr2;
        xvel:=xvel/1.1;
        yvel:=yvel/1.1;

{        xvel:=xpos-zr1;
        yvel:=ypos-zr2;}


      end;
  blobyes:=true;

  offsrot:=ofs(ship[2].shp^.data);
  segrot:=seg(ship[2].shp^.data);
  sprite[1].shape:=ptr(segrot,offsrot);


  if invuln and 2=0 then copybitmap(sprite[1].shape,sprite[1].x,sprite[1].y,true);
  if (invuln=0) and (not(lostgame)) then
  if checkinside(sprite[1].x+13,sprite[1].y+13) then
             begin
               shotx:=(sprite[1].x+13-(_leftclip*4)) div 9;
               shoty:=(sprite[1].y+13-_topclip) div 14;
               if shotx<0 then shotx:=0 else
               if shotx>32 then shotx:=32;
               if shoty<0 then shoty:=0 else
               if shoty>16 then shoty:=16;
               if mismap[shotx,shoty]+mismap[shotx-1,shoty]+
                  mismap[shotx+1,shoty]+mismap[shotx,shoty+1]+
                  mismap[shotx,shoty-1]>0 then
                 begin
                   losgame(random(10),random(5),-1,-1);
                 end;
             end; {if checkinside}


  {crot(sprite[1].x,sprite[1].y,true);}

{  if invuln and 2=0 then csprite(sprite[1],sprite[1].x,sprite[1].y,true)
   else csprite(sprite[1],sprite[1].x,sprite[1].y,false);}
  blobyes:=false;
  {drawsprite(sprite[1]);}

end;

procedure update_missiles;
var i,j,k,l,dz1,d1,d2,d3 : integer;
    r1,r2,r3: real;
    didital: boolean;
    numblue : integer;
    gggg,shotx,shoty : integer;

begin
  didital:=false;
  numblue:=0;
  for i:=0 to 50 do with missls[i] do if omap then
  begin
    mismap[omx,omy]:=0;
    omap:=false;
  end;



  for i:=0 to 50 do
    with missls[i] do
      if active then
        begin





          case strategy of
            0     :  begin  {   Direct fire    }
{                       if ((trunc(arg1) and 1)>0) and (arg1>30) then stuffbuf(1,round(arg1*4+1));}
                       x:=x+xvel;
                       y:=y+yvel;
                       arg1:=arg1-1;
                       if arg1<0 then active:=false;
                       if spnum=12 then inc(numblue);

                       {spnum:=10+random(3); }

                     end;   {   Direct fire    }
            4     :  begin  {   redirect guided}
                       if (abs(x-dum1+ship[1].xpos)+abs(y-dum2+ship[1].ypos))>320
                         then
                           begin
                              xvel:=xvel*0.8;yvel:=yvel*0.8;
                              arg1:=arg1+1;
                              dormant:=true;
{                             if x-160<-ship[1].xpos then x:=x+xvel/2
                              else x:=x-xvel/2;
                             if y-100<-ship[1].ypos then y:=y+xvel/2
                              else y:=y-xvel/2;}
                           end
                       else
                         if (x-dum1<>-ship[1].xpos) then
                         begin
                           dormant:=false;
                           r1:=arctan((y-dum2+ship[1].ypos)/(x-dum1+ship[1].xpos));
                           r2:=abs(fcos(r1));
                           r3:=fsin(r1);
                           if (x-dum1)<(-ship[1].xpos) then
                             begin
                               xvel:=xvel+r2*arg2;
                               yvel:=yvel+r3*arg2;
                             end
                           else
                             begin
                               xvel:=xvel-r2*arg2;
                               yvel:=yvel-r3*arg2;
                             end;
                         end;
                         if xvel>6 then xvel:=6
                         else if xvel<-6 then xvel:=-6;
                         if yvel>6 then yvel:=6
                         else if yvel<-6 then yvel:=-6;
                         xvel:=xvel*0.99;
                         yvel:=yvel*0.99;
                         x:=x+xvel;
                         y:=y+yvel;


                       arg1:=arg1-1;
                       if arg1<=0 then active:=false;
                       if didital=false then
                        begin
                            j:=abs(2-(cycles and 7));
                            if j>2 then j:=2;
                            sprite[4].shape:=misshape[j];
                            didital:=true;
                        end;






                     end; {      Redirect guided}

            5     :  begin  {   redirect guided with splitting}
                       if (abs(x-dum1+ship[1].xpos)+abs(y-dum2+ship[1].ypos))>320
                         then
                           begin
                             dormant:=true;
                             arg1:=5;
                             xvel:=xvel*0.8;yvel:=yvel*0.8;
                           {  if x-160<-ship[1].xpos then x:=x+xvel/2
                              else x:=x-xvel/2;
                             if y-100<-ship[1].ypos then y:=y+xvel/2
                              else y:=y-xvel/2;}
                           end
                       else
                         if (x-dum1<>-ship[1].xpos) then
                         begin
                           dormant:=false;
                           r1:=arctan((y-dum2+ship[1].ypos)/(x-dum1+ship[1].xpos));
                           r2:=abs(fcos(r1));
                           r3:=fsin(r1);
                           if (x-dum1)<(-ship[1].xpos) then
                             begin
                               xvel:=xvel+r2*arg2;
                               yvel:=yvel+r3*arg2;
                             end
                           else
                             begin
                               xvel:=xvel-r2*arg2;
                               yvel:=yvel-r3*arg2;
                             end;
                         end;
                         if xvel>6 then xvel:=6
                         else if xvel<-6 then xvel:=-6;
                         if yvel>6 then yvel:=6
                         else if yvel<-6 then yvel:=-6;
                         xvel:=xvel*0.99;
                         yvel:=yvel*0.99;
                         x:=x+xvel;
                         y:=y+yvel;


                       arg1:=arg1-1;
                       if arg1<=0 then
                         begin
                           r1:=random(628)/100;
                           xvel:=4*fcos(r1);
                           yvel:=4*fsin(r1);
                           if random(2)=0 then
                           definenewmissile(x,y,4,
          {xvel}             xvel,yvel,
          {atx}              0,0,160,1+random(10)/10,4)
                        else
                           definenewmissile(x,y,5,
          {xvel}             xvel,yvel,
          {atx}              0,0,160,0.4+random(10)/10,4);

                           r1:=r1+3.14;
                           xvel:=7*fcos(r1);
                           yvel:=7*fsin(r1);
                           arg1:=40;
                         end;

                     end; {      Redirect guided with splitting}

            6        :                    {explosion}
                        begin
                          arg1:=arg1+1;
                          spnum:=21+trunc(arg1);
                          if arg1>4 then spnum:=29-trunc(arg1);
                          if arg1=8 then
                            begin
                              active:=false;
                              spnum:=25;
                            end;
{                          if botherwithscore=false then
                            spnum:=9;                  }
                        end;             {explosion}




               end; {case}
          dz1:=mem[seg(sprite[spnum].shape^):
                   ofs(sprite[spnum].shape^)+1] div 2;
          if checkinside(trunc(x-dz1+ship[1].xpos),trunc(y-dz1+ship[1].ypos))
          then if checkinside(trunc(x+dz1+ship[1].xpos),trunc(y+dz1+ship[1].ypos)) then
            begin
              x:=x+dz1;
              y:=y+dz1;
{              gggg:=abs(sprite[1].x+10-trunc(x+ship[1].xpos))+
                    abs(sprite[1].y+10-trunc(y+ship[1].ypos));
              if gggg<100 then
                begin
                  stuffbuf(1,10-gggg div 10);
                  stuffbuf(2,10-gggg div 10);
                  if gggg<20 then

                   if hurt then
                     begin
                       losgame(sprite[1].x+10-(x+ship[1].xpos),
                               sprite[1].y+10-(y+ship[1].ypos),
                               missls[i].xvel,missls[i].yvel);
                       active:=false;
                     end;
                end;}

              if not(lostgame) and (invuln=0) then
              if (strategy in [4,5]) or ((shottype=1) and (strategy=0)){or (vuln)} then
               if (srpix_x(1+trunc(x+ship[1].xpos),
                 trunc(y+ship[1].ypos))>222) then
                 begin
                   active:=false;
                   if not(vuln) then                for d3:=1 to 5 do
              begin
                d1:=trunc(x+ship[1].xpos)
                   +random(31)-15;
                d2:=trunc(y+ship[1].ypos)
                   +random(31)-15;
                if checkinside(d1,d2) then
                     copybitmap(sprite[5+random(2)].shape,d1,d2,true)
             end;

             end;
             x:=x-dz1*2;
             y:=y-dz1*2;
             if active then
             begin
             IF STRATEGY=0 THEN copyMISmap2(sprite[spnum].shape,trunc(x+ship[1].xpos),trunc(y+ship[1].ypos),true)
             else IF STRATEGY=6 THEN copyMISmap(sprite[spnum].shape,trunc(x+ship[1].xpos),trunc(y+ship[1].ypos),true)
             ELSE copyBITmap(sprite[spnum].shape,trunc(x+ship[1].xpos),trunc(y+ship[1].ypos),true);
             if strategy in [0,4,5] then checkclose(trunc(x+ship[1].xpos)+2,trunc(y+ship[1].ypos)+2);

             end;
{ $R+}
{ $Q+}
{ $I+}

             x:=x+dz1;
             y:=y+dz1;
             omap:=false;
             if hurt then
             if checkinside(trunc(x+ship[1].xpos)+4,trunc(y+ship[1].ypos)+4) then
             begin
               shotx:=(trunc(x+ship[1].xpos)+4-(_leftclip*4)) div 9;
               shoty:=(trunc(y+ship[1].ypos)+4-_topclip) div 14;
               if shotx<0 then shotx:=0 else
               if shotx>32 then shotx:=32;
               if shoty<0 then shoty:=0 else
               if shoty>16 then shoty:=16;
               mismap[shotx,shoty]:=255;
               omx:=shotx;
               omy:=shoty;
               omap:=true;
             end; {if checkinside}

            end;

{ $R-}
{ $Q-}
{ $I-}
        end;
  if blueback<numblue div 2 then blueback:=numblue div 2;
end;




procedure up_date_cshot;

const
   temp2 : real=0.0;
   temp3 : real=0.0;
var i : integer;
   jb2 : integer;
   jb3 : integer;
   ii,k : integer;
   tr2:real;

begin
with cshot do
begin
{     if xpos>-99 then
         begin
           setcolor(255);
           xpos:=xpos+xvelc;
           ypos:=ypos+yvelc;
           moveto(xpos,ypos);
           if checkinside(xsc,ysc) then
             begin

               copysprite(sprite[10],xsc,ysc);
             end
           else xpos:=-99;
         end
     else}
        begin
          temp2:=ship[3].ang-thet;
          while temp2>(3.14159+3.14159) do temp2:=temp2-3.14159-3.14159;
          while temp2<0 do temp2:=temp2+3.14159+3.14159;
          jb2:=trunc(temp2/(3.14159+3.14159)*8);
          temp3:=3.14159-(ship[3].ang+thet);
          while temp3>(3.14159+3.14159) do temp3:=temp3-3.14159-3.14159;
          while temp3<0 do temp3:=temp3+3.14159+3.14159;
          jb3:=8+trunc(temp3/(3.14159+3.14159)*8);
          if ((shield[jb2]=0) and ((shield[jb2+16]=0) and (shield[jb3]=0)))
            or (diam<xdiam div 2)
            then
              if not(dontbother) then
                for i:=1 to 2 do begin
                  drot:=ship[3].ang+((integer(random(101))-50)/300);
                  xpos:=trunc(5*FCOS(drot));
                  ypos:=trunc(5*FSIN(drot));
                  k:=random(20);
                  xvelc:=trunc((15+(k/10))*fcos(drot));
                  yvelc:=trunc((15+(k/10))*fsin(drot));
                  definenewmissile(xpos,ypos,0,
          {xvel}           xvelc,yvelc,
          {atx}            0,0,19+random(5),-1,10+random(3));

                end;
        end;
end;
end;




{
procedure update_cship;

var
  os : real;
  at : real;
  t1,t2,t8: integer;
  temp : real;
  t3 : integer;
  cc1,cc2 : integer;
  mt : real;
  tttx,ttty : real;
  shx,shy   : integer;
begin
  tttx:=2*round(ship[1].xvel);
  ttty:=2*round(ship[1].yvel);
  shx:=round(-ship[1].xpos+160);
  shy:=round(-ship[1].ypos+100);
  os:=ship[3].ang;

  temp := shx-tttx;
  if abs(temp)<0.01 then temp:=0.01;

  at:=abs(arctan(((shy-ttty)/temp)));

  mt:=0.0281747*timeinc;

  if shy-ttty<0 then
      begin
        if shx-tttx<0 then at:=at+pi
         else at:=(pi*2)-at;
      end
      else
        if shx-tttx<0 then at:=pi-at;

  while abs(at-os)>pi do
      begin
        if at-os>pi then at:=at-(pi*2)
        else at:=at+(pi*2);
      end;

  dontbother:=abs(at-os)>(pi/3);
  if abs(at-os)>(mt) then
    begin
      if at>os then ship[3].ang:=ship[3].ang+mt
      else             ship[3].ang:=ship[3].ang-mt;
    end;

  os:=ship[3].ang;

  if os>(2*pi) then os:=os-(2*pi);
  if os<0 then os:=os+(2*pi);
  ship[3].ang:=os;


  t1:=round(os*64/(pi*2))+15;
  if t1>63 then dec(t1,63);

  while ship[3].rot<t1 do
    begin
      ship[3].rot:=ship[3].rot+1;
      ship[3].shp:=ship[3].shp^.prev;
    end;
  while ship[3].rot>t1 do
    begin
      ship[3].rot:=ship[3].rot-1;
      ship[3].shp:=ship[3].shp^.next;
    end;


  move(ship[3].shp^.data,sprite[3].spritedata,(27*27)-1);
  with sprite[3] do
    begin
      x:=scrposx-13;
      y:=scrposy-13;

    end;

end;}


procedure doborder;
var i : integer;
begin
{  pp:=ptr(segA000,0);
  fillchar(pp^,(320*15),0);
  pp:=ptr(sega000,(320*184));
  fillchar(pp^,(320*15),0);}
end;

{procedure bigdiam;
var  i:integer;
begin
  for i:=0 to 7 do shield[i]:=0;
  rotateshell;
  for i:=1 to 4 do mis[i]:=mis[i+2];
  for i:=0 to 15 do shield[i]:=shield[i+8];
  for i:=16 to 23 do shield[i]:=13;
  mis[5]:=true;
  mis[6]:=true;
  dor:=-dor;
end;}

procedure update_screen_objects(num:integer);
var i,j,k,l,m:integer;

begin
  dostarsq:=true;
  exit;
  for i:=0 to 0 do
    if scrobj[i].active=true then
      with scrobj[i] do
        begin
          j:=(round(ship[num].xpos) div 2)+x+390;
          k:=(round(ship[num].ypos) div 2)+y-50;
          if abs(j-140)+abs(k-100)<150 then
            begin
              l:=(10000-sqr(j-140)-sqr(k-100)) div 800;
              if l<0 then l:=0;
              if l>63 then l:=63;
              if redback<l then redback:=l;
              if greenback<l then greenback:=l;
              if blueback<l then blueback:=l;
              if l>8 then dostarsq:=false;
            end;

{          if (checkinside(j,k)) and
             (checkinside(j+sprite[spnum].w,k+sprite[spnum].h)) then}
               copybitmap(sprite[spnum].shape,j,k,TRUE);




        end;

  WITH SCROBJ[1] DO
  BEGIN
    J:=round(ship[num].xpos{*0.5})+x;
    k:=round(ship[num].ypos{*0.5})+y;

    COPYBITMAP(SPRITE[SPNUM].SHAPE,J,K,TRUE);
  END;


end;

procedure update_quasar;
var z,i,j,k,l,shx,shy,tttx,ttty,d1,d2,d3 : integer;
    temp,at : real;
    pp : word;
    pz : word;
    shotx,shoty:integer;
    os,r1,r2,r3:real;
    b1,b2 : boolean;


begin
  if shottype<>1 then exit;
  if closed<600 then copybitmap(sprite[49].shape,closex-5,closey-5,true);

  clear_shotmap;
  inc(shottime);
  countshots:=0;
  {if not(buttonpushed[1]) then shottime:=10000;}
  if shottime>shotlevel*15 then
    begin
      shottime:=shotlevel*15;
      if buttonpushed[1] then quasarstart:=true;
    end;
  if shottime<=(shotlevel) then quasarstart:=false;

  pz:=word((shottime div shotlevel)+17);
  if pz>31 then pz:=255;
  pz:=pz+pz shl 8;
  pp:=314;
{  while pp<(320*199) do                        *** fix this ***
    begin
      inc(pp,320);
      memw[sega000:pp]:=pz;
      memw[sega000:pp+2]:=pz;
      memw[sega000:pp+4]:=pz;
    end;}



  if quasarstart {and not(cycles and 1=0)} then
{    if (shotcount) then}
for d3:=1 to 2{numshot} do
      begin
        k:=-1;
        for i:=maxshot downto 2 do
         if shotsprite[i].active=false then k:=i;
        if k<>-1 then
          begin
            inc(ssnums);
{            stuffbuf(1,100+shottime*5);
            stuffbuf(1,100);}
            shotsprite[k].active:=true;
            shot[k].ang:=2*ship[1].ang*3.14159/64+pook;
            shot[k].dy:=-fcos(shot[k].ang){+pook}*11;
            shot[k].dx:=fsin(shot[k].ang){+pook}*11;
            shotsprite[k].x:=trunc(sprite[1].x)+2*round(shot[k].dx);
            shotsprite[k].y:=trunc(sprite[1].y)+2*round(shot[k].dy);
            shot[k].tone:=1000;
if d3=1 then             dec(shottime,shotlevel);          {(******)}

{            shottime:=0;}
            {sound(30);}
            ship[1].xvel:=ship[1].xvel+(shot[k].dx/40);
            ship[1].yvel:=ship[1].yvel+(shot[k].dy/40);
{            shotsprite[k].x:=shotsprite[k].x+round(shot[k].dy);
            shotsprite[k].y:=shotsprite[k].y-round(shot[k].dx);}
            shotcount:=not(shotcount);
          end;
 {      end}
{       else              }
{       begin}

{        k:=-1;
        for i:=maxshot downto 2 do
         if shotsprite[i].active=false then k:=i;
        if k<>-1 then
          begin
            shotsprite[k].active:=true;
            shot[k].dy:=-fcos((2*ship[1].ang*3.14159/64)+pook)*15;
            shot[k].dx:=fsin((2*ship[1].ang*3.14159/64)+pook)*15;
            shotsprite[k].x:=trunc(sprite[1].x)+8+1*round(shot[k].dx);
            shotsprite[k].y:=trunc(sprite[1].y)+8+1*round(shot[k].dy);
            shot[k].tone:=1000;
            shotsprite[k].x:=shotsprite[k].x-round(shot[k].dy);
            shotsprite[k].y:=shotsprite[k].y+round(shot[k].dx);
            shotcount:=not(shotcount);
          end;}
      end;

  for i:=2 to maxshot do
    if (shotsprite[i].active) then
      begin
        inc(countshots);
        dec(shot[i].tone,1);
        if shot[i].tone<10 then shot[i].tone:=10;

{        stuffbuf(1,shot[i].tone div 120);}

        shotsprite[i].x:=shotsprite[i].x+round(shot[i].dx*timeinc/1.5);
        shotsprite[i].y:=shotsprite[i].y+round(shot[i].dy*timeinc/1.5);
        if ((shotsprite[i].x<0) or (shotsprite[i].x>319)) or
           ((shotsprite[i].y<0) or (shotsprite[i].y>239)) then
            begin
              dec(ssnums);
              shotsprite[i].active:=false
            end
        else
          begin
            hit:=false;
            if centerexists then sshots(i);





            if (hit) then
            begin




                if offsset<0.5 then offsset:=offsset+(random(10)/150);
                for d3:=1 to 5 do
             begin
                d1:=((shotsprite[i].x+trunc(ship[1].xpos)) div 2)
                   +random(31)-15;
                d2:=((shotsprite[i].y+trunc(ship[1].ypos)) div 2)
                   +random(31)-15;
{                if checkinside(d1,d2) then}
                     copybitmap(sprite[5+random(2)].shape,d1,d2,true)
             end;
            end;

          end;

      end;
  for i:=2 to maxshot do
    if (shotsprite[i].active) then
      begin
{        if shot[i].tone>998 then
            copyMISmap(sprite[12].shape,shotsprite[i].x+4,shotsprite[i].y+4,false)
        else if shot[i].tone>995 then
            copyMISmap(sprite[12].shape,shotsprite[i].x+2,shotsprite[i].y+3,false)
        else if shot[i].tone>991 then
           copyMISmap(sprite[10].shape,shotsprite[i].x+2,shotsprite[i].y+3,false)
        else}
           copyMISmap(sprite[2].shape,shotsprite[i].x+3,shotsprite[i].y+3,false);

        shotx:=(shotsprite[i].x+3-(_leftclip*4)) div 9;
        shoty:=(shotsprite[i].y+3-_topclip) div 14;
        if shotx<0 then shotx:=0 else
        if shotx>32 then shotx:=32;
        if shoty<0 then shoty:=0 else
        if shoty>16 then shoty:=16;
        shotmap[shotx,shoty]:=255;


        if (closed<600) and (shot[i].tone>980) then
        begin
          shx:=closex-(shotsprite[i].x+3);
          shy:=closey-(shotsprite[i].y+3);
          os:=shot[i].ang;

          r1:=shx*fcos(os)+shy*fsin(os);
          r3:=shx*fcos(os+(pi/2))+shy*fsin(os+(pi/2));
          b1:=r1>0;
          b2:=r3>0;
          {dbother:=not(b1);}

          with shot[i] do
          {if b2 then}
          begin
            if b1   then begin
                     ang:=ang+((2*pi)/32);
                     shot[i].dy:=-fcos(shot[i].ang){+pook}*11;
                     shot[i].dx:=fsin(shot[i].ang){+pook}*11;
                   end
                else
                   begin
                     ang:=ang-((2*pi)/32);
                     shot[i].dy:=-fcos(shot[i].ang){+pook}*11;
                     shot[i].dx:=fsin(shot[i].ang){+pook}*11;
                   end;
          end;
        end;






      end;

  if redback<(countshots div 2) then redback:=(countshots div 2);
  if greenback<(countshots div 3) then greenback:=(countshots div 3);
  if blueback<(countshots) then blueback:=(countshots);









  closed:=5000;
end;





{$I enemy4.inc}


procedure losgame(rx1,ry1,dx1,dy1:real);
var a1,a2,a3,rx2,ry2,r1,r2,r3,r4:real;
    shxz,shyz,d1,d2,d3,i1,i2,i3,i4,i5,zd1,zd2,zd3,zd4 : integer;
    oldtog : boolean;
    butpushed : boolean;
begin
  if lostgame then exit;
  oldtog:=toggle;
  butpushed:=false;

  lostgame:=true;
  rx2:=rx1+dx1;
  ry2:=ry1+dy1;


  shxz:=round(-ship[1].xpos+dum1-2*(ship[1].xvel));
  shyz:=round(-ship[1].ypos+dum2-2*(ship[1].yvel));

  if invuln=0 then
    begin
      definenewmissile(shxz,shyz,6,0,0,0,0,0,0,0);
      dec(health);
      invuln:=10;
    end;
  i5:=timeguess;
  if health<0 then
    begin
      toggle:=false;
      invuln:=20;
      clearmissiles;
      pal[0].rn:=60;
      pal[0].bn:=60;
      pal[0].gn:=60;
      setvgapalette(pal);
      for d3:=0 to 15 do
            begin
             r1:=fsin(d3)*5;
             r2:=fsin(d3*2)*5;
             definenewmissile(shxz,shyz,0,r1,
                                      r2,0,0,random(20)+10
                                      ,0,8+random(3));
            end;
{      while r1<1 do r1:=(sin(random(10))*4);}
{      while r2<1 do r2:=(sin(random(10))*4);}
      r3:=ship[1].xpos;
      r4:=ship[1].ypos;

      for d3:=0 to 10 do
        begin
              pal[0].bn:=(10-d3)*4;
              pal[0].gn:=(10-d3)*4;
              pal[0].rn:=(10-(d3 div 2))*4;
              setvgapalette(pal);
          for d1:=1 to 15 do
           begin
             r1:=fsin(d3+d1)*5-ship[1].xvel/2;
             r2:=fsin(d3-d1)*5-ship[1].yvel/2;
             definenewmissile(shxz,shyz,0,r1,
                                      r2,0,0,random(20)+10
                                      ,0,8+random(3));
             makesnd;
            end;
          d1:=25-abs(25-d3);
          r3:=r3+ship[1].xvel;
          r4:=r4+ship[1].yvel;
          shxz:=round(-r3+dum1-2*(ship[1].xvel));
          shyz:=round(-r4+dum2-2*(ship[1].yvel));
          ship[1].xpos:=r3{+sin(d3/2)*(d1*d1/2)};
          ship[1].ypos:=r4{+cos(d3/2)*(d1*d1/2)};
          slowmachine:=((timereal<timeguess) and doslowcheck) or slow2;
          while timereal>timeguess do ;
          timereal:=timeguess;
          tcountz:=0;
          {showvirtualscreen2;}
          clearpagestar;
          flip;

          CORRECTSCREENPOS;


          scrposx:=trunc(ship[1].xpos);
          scrposy:=trunc(ship[1].ypos);
              xxxpos:=-ship[1].xpos;
    yyypos:=-ship[1].ypos;
          UPDATE_SCREEN_OBJECTS(1);

          sprite[1].x:=dum1-14-2*round(ship[1].xvel){-trunc(sin(d3/2)*(d1*d1/6))};
          sprite[1].y:=dum2-14-2*round(ship[1].yvel){-trunc(cos(d3/2)*(d1*d1/6))};
          if random(2)=1 then copybitmap(sprite[1].shape,sprite[1].x,sprite[1].y,true);
          for zd3:=1 to random(5)+1 do
              begin
                zd1:=trunc(sprite[1].x)
                   +random(31)-15;
                zd2:=trunc(sprite[1].y)
                   +random(31)-15;
{                if checkinside(zd1,zd2) then}
                     copybitmap(sprite[13].shape,zd1,zd2,true)
             end;

{          if centerexists then
          begin
            rotateshell;
          end;}

          update_missiles;
          update_enemy;



{          if centerexists then update_cship;}
{          update_enemy;}



          timereal:=timereal+GG2;
          if offsset>(timeinc/20) then offsset:=offsset-(timeinc/20) else
            offsset:=0;
{          getbuttons;
          butpushed:=butpushed or buttonpushed[1];
          if butpushed then break;}
        end;



      for d3:=0 to 50 do
        begin
          for d1:=1 to 15 do
           begin
             r1:=fsin(d3+d1)*5-ship[1].xvel/2;
             r2:=fsin(d3-d1)*5-ship[1].yvel/2;
             definenewmissile(shxz,shyz,0,r1,
                                      r2,0,0,random(10)+10
                                      ,0,8+random(3));
             makesnd;
            end;
          d1:=25-abs(25-d3);

          r3:=r3+ship[1].xvel;
          r4:=r4+ship[1].yvel;
          shxz:=round(-r3+dum1-2*(ship[1].xvel));
          shyz:=round(-r4+dum2-2*(ship[1].yvel));
          ship[1].xpos:=r3+sin(d3/2)*(d1*d1/6){ship[1].xpos+r1};
          ship[1].ypos:=r4+cos(d3/2)*(d1*d1/6){ship[1].ypos+r2};

          slowmachine:=((timereal<timeguess) and doslowcheck) or slow2;
          while timereal>timeguess do ;
          timereal:=timeguess;
          tcountz:=0;
          {showvirtualscreen2;}
          clearpagestar;
          flip;
          CORRECTSCREENPOS;

          scrposx:=trunc(ship[1].xpos);
          scrposy:=trunc(ship[1].ypos);
              xxxpos:=-ship[1].xpos;
    yyypos:=-ship[1].ypos;
          UPDATE_SCREEN_OBJECTS(1);

          sprite[1].x:=dum1-14-2*round(ship[1].xvel)+trunc(sin(d3/2)*(d1*d1/6));
          sprite[1].y:=dum2-14-2*round(ship[1].yvel)+trunc(cos(d3/2)*(d1*d1/6));
          if random(2)=1 then copybitmap(sprite[1].shape,sprite[1].x,sprite[1].y,true);
          if d3<40 then
          for zd3:=1 to random(5)+1 do
              begin
                zd1:=trunc(sprite[1].x)
                   +random(31)-15;
                zd2:=trunc(sprite[1].y)
                   +random(31)-15;
{                if checkinside(zd1,zd2) then}
                     copybitmap(sprite[13].shape,zd1,zd2,true)
             end;

{          if centerexists then
          begin
            rotateshell;
          end;}
          update_missiles;
          update_enemy;



{          if centerexists then update_cship;}
{          update_enemy;}



          timereal:=timereal+GG2;
          if offsset>(timeinc/20) then offsset:=offsset-(timeinc/20) else
            offsset:=0;
          getbuttons;
          butpushed:=butpushed or buttonpushed[1];
          if butpushed then break;
        end;





      health:=10;          {*******}
      pal[0].gn:=0;
      pal[0].bn:=0;
      pal[0].rn:=0;
      setvgapalette(pal);
      toggle:=oldtog;
      nextguy;
      toggle:=false;

    end;                        {end of if your dead}



  updatescreen;
{  nosound;}
  for d3:=1 to 5 do
              begin
                d1:=trunc(sprite[1].x)
                   +random(31)-15;
                d2:=trunc(sprite[1].y)
                   +random(31)-15;
{                if checkinside(d1,d2) then}
                     copybitmap(sprite[13].shape,d1,d2,true)
             end;

  if not(
     ((abs(rx1)<0.4) or (abs(ry1)<0.4)) or
     ((abs(rx2)<0.4) or (abs(ry2)<0.4)) )
     then
     begin
       a1:=arctan(ry1/rx1);
       a2:=arctan(ry2/rx2);
       a3:=a1-a2;
       if abs(a3)<pi then
        begin

          if a3<0 then begin
                         ship[1].rotd:=ship[1].rotd-2;
                       end
                          else
                       begin
                         ship[1].rotd:=ship[1].rotd+2;
                       end;
          if abs(dx1)>0.1 then
            begin
{              a1:=arctan(dy1/dx1);
              if a1>(pi/2) then a1:=a1-pi;
              a1:=a1+((pi*a3)/(abs(a3)*16));
              if dx1<0 then a1:=-a1;}

              ship[1].xvel:=ship[1].xvel-(dx1/5);  {(cos(a1)*1);}
              ship[1].yvel:=ship[1].yvel-(dy1/5);  {(sin(a1)*1);}
            end;
        end;

     end;
  lostgame:=false;
  toggle:=oldtog;

end;

procedure loadsprite(i:integer;tt:string);
var ff : file of byte;
    f2 : file;
    w,h : byte;
    size : word;
    ppp : pointer;
begin
                                        {get rid of old sprite data}
  if sprite[i].shape<>nil then
    begin
    w:=mem[seg(sprite[i].shape^):ofs(sprite[i].shape^)];
    h:=mem[seg(sprite[i].shape^):ofs(sprite[i].shape^)+1];

    size:=w*h*4+2;
    freemem(sprite[i].shape,size);
    end;



  assign(ff,tt);
  reset(ff);
  read(ff,w);
  read(ff,h);
  close(ff);

  assign(f2,tt);
  size:=w*h*4+2;
  reset(f2,size);
  if maxavail<size then begin sound(440);delay(50);nosound; end;
  getmem(sprite[i].shape,size);
  blockread(f2,sprite[i].shape^,1);
  close(f2);
end;

procedure resetsprites;
var i :integer;
begin
  for i:=0 to maxsprites do
    sprite[i].shape:=nil;
end;


{$I nextguy.inc}

procedure installtimerhandler;
begin
  getintvec(8,oldtimerhandler);
  setintvec(8,addr(timer));
  port[$21]:=port[$21] and $fe;
  port[$43]:=$34;
  port[$40]:=byte(6666 and $FF);
  port[$40]:=(6666-byte(6666 and $FF)) shr 8;
end;


procedure initsound; assembler;
asm
  mov al,10110110b
  out 43h,al
  mov ax,1
  out 42h,al
  mov al,ah
  out 42h,al
  in al,61h
  or al,00000011b
  out 61h,al
end;


procedure dochangeover;
begin
end;





PROCEDURE SETUPPLANET;
var i,j,k:integer;
BEGIN
  for j:=0 to 1 do
  for i:=0 to 1 do
    begin
      k:=i+2*j;
      scrobj[k].active:=true;
      scrobj[k].x:=130+i*33-33;
      scrobj[k].y:=130+j*29-29;
      scrobj[k].spnum:=k+14;
      scrobj[k].solar:=false;

    end;

end;

procedure newsetpal(col,r,g,b:byte);
begin
  port[$3c8]:=col;
  port[$3c9]:=r;
  port[$3c9]:=g;
  port[$3c9]:=b;
end;

begin                   {MAIN PROGRAM}
  resetsprites;
  cycles:=0;

  {getintvec($1c,int1csave);}

  lostgame:=false;
  maxshot:=xmaxshot;
  for d1:=1 to 6 do mis[d1]:=true;
  diam:=40;
  xdiam:=diam;
  new(movbuf);
  new(star_screen);
  sgg1:=seg(star_screen^[0,0,0]);
  off1:=ofs(star_screen^[0,0,0]);


{  randomize;}
  shottime:=0;
  init;


  stand_pal;
  pal[1].rn:=1;
  pal[1].bn:=2;
  pal[1].gn:=1;
{  blank:=pal;}
  setvgapalette(blank);
  makescreen;
  setvgapalette(pal{redp});
  installtimerhandler;
{  flickinscreen;}
{  loadfailed;     }
  setupinp;
{  flickinfailed;}


  for d1:=0 to 2 do new(misshape[d1]);

  GETrot(ship[13],'temp\cloak3.rt4');
  getrot(ship[12],'temp\uncloak.rt4');
{  ship[13]:=ship[12];}

  GETROT(SHIP[2],'temp\butter.rt4');
  getrot(ship[3],'temp\bomber2.rt4'{'temp\attk1.rt4'});
  getrot(ship[4],{'temp\ship2.rt4'}'temp\attk1.rt4');
  loadsprite(2,'spr\shot4.sp4');

  loadsprite(4,'spr\boob.sp4');
  misshape[0]:=sprite[4].shape;

  loadsprite(47,'spr\boob2.sp4');
  misshape[1]:=sprite[47].shape;

  loadsprite(48,'spr\boob3.sp4');
  misshape[2]:=sprite[48].shape;

  loadsprite(5,'spr\shot3.sp4');
  loadsprite(6,'spr\boom1.sp4');
  loadsprite(7,'spr\shot4b.sp4');
  loadsprite(8,'spr\shot4c.sp4');
  loadsprite(9,'spr\shot4d.sp4');

  loadsprite(10,'spr\cshot1.sp4');
  loadsprite(11,'spr\cshot2.sp4');
  loadsprite(12,'spr\cshot3.sp4');

  loadsprite(13,'spr\explo.sp4');
  for d1:=0 to 3 do scrobj[d1].active:=false;

{  loadsprite(14,'obj00-9');
  loadsprite(15,'obj10-9');
  loadsprite(16,'obj01-9');
  loadsprite(17,'obj11-9');}
{  loadsprite(14,'obj1.sp4');}
(*  LOADSPRITE(14,{'TEMP\moon1.SP4'}'temp\sun1.sp4');
  LOADSPRITE(15,'OBJ1.SP4');
                            *)
  loadsprite(18,'spr\tshot4.sp4');
  loadsprite(19,'spr\tshot4b.sp4');
  loadsprite(20,'spr\tshot4c.sp4');
  loadsprite(21,'spr\tshot4d.sp4');

  loadsprite(22,'spr\exp1.sp4');
  loadsprite(23,'spr\exp2.sp4');
  loadsprite(24,'spr\exp3.sp4');
  loadsprite(25,'spr\exp4.sp4');

  loadsprite(26,'spr\0.sp4');
  loadsprite(27,'spr\1.sp4');
  loadsprite(28,'spr\2.sp4');
  loadsprite(29,'spr\3.sp4');
  loadsprite(30,'spr\4.sp4');
  loadsprite(31,'spr\5.sp4');
  loadsprite(32,'spr\6.sp4');
  loadsprite(33,'spr\7.sp4');
  loadsprite(34,'spr\8.sp4');
  loadsprite(35,'spr\9.sp4');

  loadsprite(36,'temp\death1.sp4');
  loadsprite(49,'spr\xhair.sp4');


  setupplanet;
  clear_enemy;

  for d1:=0 to 4 do
  begin
   d3:=trunc(sin(random(100))*500)+1255;
   d2:=trunc(sin(random(100))*500)+1255;
   newenemyship(d3,d2,3,2,-1,5,true);
  end;

  menleft:=3;

{  for d1:=0 to 33 do}
    {newenemyship(random(100),random(100),12+random(2),1,-1,10); }
{    begin
      d3:=trunc(sin(random(100))*500)+1255;
      d2:=trunc(sin(random(100))*500)+1255;
      if random(2)=0 then
      squad(d3,d2,13,1,0,2+random(4),20+random(20),false)
      else
      if random(2)=0 then squad(d3,d2,12,1,1,2+random(4),20+random(20),true)
      else squad(d3,d2,4,1,1,2+random(4),20+random(20),true)
    end;}

  enemysonthislevel:=33;

{  with sprite[1] do
    begin
      oldx:=-1;
      w:=27;
      h:=27;
    end;
  with sprite[3] do
    begin
      oldx:=-1;
      w:=27;
      h:=27;
    end;}
  SHIP[1].XPOS:=SCRPOSX;
  SHIP[1].YPOS:=SCRPOSY;
  ship[1].ang:=0;
  ship[1].rot:=0;
  makestars;

{  sprite[1].active:=false;}
  sprite[1].x:=142;
  sprite[1].y:=82;
  sprite[1].shape:=ship[1].shp^.data;
  with ship[1] do begin
                    xvel:=0;
                    yvel:=0;
                  end;


  changedpal:=false;
  {****}
{  for d1:=2 to 5 do
  set_pal(120+d1,30,10,10);
  set_pal(121,25,15,15);
  set_pal(126,25,15,15);
  set_pal(120,10,10,30);
  set_pal(127,10,10,30);}

  copytovis;

  clearpagestar;
  setvgapalette(pal);   {****}
{  pp:=ptr(sega000,0);}
{  fillchar(ptr(sega000,0)^,(320*200),243);}

  for d1:=0 to 23 do
     shield[d1]:={74}13;
  timereal:=0;
  timeguess:=0;
  scrposx:=0;scrposy:=0;
  clearpagestar;
  updatescreen;
{  makescreen;}

{  setintvec($1c,addr(timer));}



  ship[8]:=ship[1];
  ship[9]:=ship[2];
{  clearpagestarwhite;
  flip;
  clearpagestarwhite;}
  initsound;
{  nextguy;}
    scrposx:=trunc(ship[1].xpos);
    scrposy:=trunc(ship[1].ypos);
    xxxpos:=-ship[1].xpos;
    yyypos:=-ship[1].ypos;

{  if musicon then modstart;}

  repeat
     slow2:=numon;
     doslowcheck:=slow2;

{    drawsprites;}
     if ((buttonpushed[2]) and not(obp2)) and (not(changeover)) then
      begin
        changeover:=true;
        dochangeover;
        stuffbuf(1,300);
      end;
     obp2:=buttonpushed[2];

    if (changeover) and (countshots=0) then
      begin
        inc(shottype);
        if shottype=topshot then shottype:=0;
        changeover:=false;
      end;


    slowmachine:=((timereal<timeguess) and doslowcheck) or slow2;
{    slowmachine:=true;     }
{    slow2:=timereal<timeguess;}
    botherwithscore:=(timereal>timeguess);
    changedpal:=redback+greenback+blueback>0;
    if true{botherwithscore} then               {CHANGE THIS BACK!!!}
        begin
          updateshotlevel;



          if redback>0 then
            dec(redback,1);
          if greenback>0 then
            dec(greenback,1);
          if blueback>0 then
            dec(blueback,1);
          if changedpal then newsetpal(0,redback div 2,greenback div 2,blueback div 2);


        end
        else
         if changedpal then
          begin
            if redback>0 then
              dec(redback,1);
            if greenback>0 then
              dec(greenback,1);
            if blueback>0 then
              dec(blueback,1);
            if redback+greenback+blueback=0 then newsetpal(0,0,0,0);
          end;

    while timereal>timeguess do;


    timereal:=timeguess;
    tcountz:=0;






{    waitforverticalretrace;}
    {showvirtualscreen2;}

    UPDATE_SCREEN_OBJECTS(1);

{if not(slow2) then
  begin}
   clearpagestar;
   flip;
{  end
  else nodrawflip;}

{    if (slowmachine) and (maxshot>6) then dec(maxshot);}

{if slowmachine then {sound(440) else nosound;}
       {fillchar(virtual_screen^,(300*200)-1,0)
       else             }
       CORRECTSCREENPOS;

    scrposx:=trunc(ship[1].xpos);
    scrposy:=trunc(ship[1].ypos);
    xxxpos:=-ship[1].xpos;
    yyypos:=-ship[1].ypos;

    makesnd;
{    if centerexists then
      begin
        rotateshell;
        up_date_cshot;
      end;}

    update_shots;
    update_quasar;
    makesnd;


    makesnd;
    update_ship;
    makesnd;
{    if centerexists then
      begin
        update_cship;
        makesnd;
      end;}
    update_enemy;
    makesnd;
    update_missiles;



    timereal:=timereal+GG2;
    if offsset>(timeinc/20) then offsset:=offsset-(timeinc/20) else
      offsset:=0;
{
    if centerexists then
    begin
     if (trunc(timereal) and 512)<>((trunc(timereal)-1) and 512) then
       begin
         diamchange:=-round(1*timeinc);
         if diamchange=0 then diamchange:=1;
         timereal:=1;
       end;

     diam:=diam+diamchange;
     if diam<10 then
      begin
        diamchange:=-diamchange;
        bigdiam;
      end;
     if diam>xdiam then
       begin
         diamchange:=0;
         diam:=xdiam;
       end;
    end;} {centerexists}
{    newsetpal(1,random(10),random(10),random(10));}

    if invuln>0 then dec(invuln);

    inc(cycles);
    if cycles=256 then cycles:=0;
    makesnd;
{    if cycles and 7=0 then updateshotlevel;}
  until SCROLLON;

  set_scroll(false);

{  if musicon then modstop;}

  textmode($03);

  {setintvec($1c,int1csave);}
  uninstalltimerhandler;

  nosound;
  writeln(maxavail,'   ',memavail);
end.




