{$R-}
{$Q-}
{$S-}
{$E-}

unit svga;

interface

uses dos;
type DacPalette256 = array[0..255] of array[0..2] of Byte;

var
  _rows : array[0..201] of word;

procedure setvgapalette(palbuf : dacpalette256);
procedure getvgapalette(var palbuf : dacpalette256);
procedure ppix(x,y:integer;c:byte);
function rpix(x,y:integer):byte;
procedure videomode (mode : byte);
procedure stand_pal(var palbuf:dacpalette256);


implementation

procedure set_pal(var palbuf:dacpalette256;n:byte;r,g,b:integer);
begin
  palbuf[n,0]:=r;
  palbuf[n,1]:=g;
  palbuf[n,2]:=b;
end;

procedure stand_pal(var palbuf:dacpalette256);
var i:integer;

begin
  for i:=0 to 15 do
    begin
      set_pal(palbuf,i,4*i,4*i,4*i);
      set_pal(palbuf,i+16,4*i,0,0);
      set_pal(palbuf,i+32,0,4*i,0);
      set_pal(palbuf,i+48,0,0,4*i);
      set_pal(palbuf,i+64,4*i,4*i,0);
      set_pal(palbuf,i+80,4*i,0,4*i);
      set_pal(palbuf,i+96,0,4*i,4*i);
      set_pal(palbuf,i+112,4*i,63,63);
      set_pal(palbuf,i+128,63,4*i,63);
      set_pal(palbuf,i+144,63,63,4*i);
      set_pal(palbuf,i+160,4*i,4*i,63);
      set_pal(palbuf,i+176,4*i,63,4*i);
      set_pal(palbuf,i+192,63,4*i,4*i);
      set_pal(palbuf,i+208,4*i,63,0);
      set_pal(palbuf,i+224,63,4*i,0);
      set_pal(palbuf,i+240,4*i,2*i,0);
    end;
end;

procedure ppix(x,y:integer;c:byte);
begin
  mem[sega000:(_rows[y]+x)]:=c;
end;

function rpix(x,y:integer):byte;
begin
  rpix:=mem[sega000:(_rows[y]+x)];
end;

(* Setvgapalette sets the entire 256 color palette *)
(* PalBuf contains RGB values for all 256 colors   *)
(* R,G,B values range from 0 to 63	           *)
procedure SetVGAPalette(PalBuf : DacPalette256);
var
  Reg : Registers;

begin
  reg.ax := $1012;
  reg.bx := 0;
  reg.cx := 256;
  reg.es := Seg(PalBuf);
  reg.dx := Ofs(PalBuf);
  intr($10,reg);
end;

procedure GetVGAPalette(var PalBuf : DacPalette256);
var
  Reg : Registers;

begin
  reg.ax := $1017;
  reg.bx := 0;
  reg.cx := 256;
  reg.es := Seg(PalBuf);
  reg.dx := Ofs(PalBuf);
  intr($10,reg);
end;

procedure setup;
var _i : word;
begin
  for _i:=0 to 199 do _rows[_i]:=_i*320;
end;

Procedure VideoMode ( Mode : Byte );

    Begin { VideoMode }
      Asm
        Mov  AH,00
        Mov  AL,Mode
        Int  10h
      End;
    End;  { VideoMode }


begin
  setup;
end.



