procedure mshape(xhot, yhot : integer; var cursor : curarray);
{ xhot and yhot pixel designations for the cursor hot spot. cursor is the array
 containing the cursor shape.  curarray is array type defined as
 ARRAY[0..31] OF INTEGER }


var recpack : registers;

begin
   with recpack do
   begin
      ax := 9;
      bx := xhot;
      cx := yhot;
      dx := Ofs(cursor[0]);
      es := Seg(cursor[0])
   end;
   intr($33, recpack)
end;

procedure mstatus(var mstat, nbuttons : integer);
{ returns mouse status and resets mouse parameters.  mstat=0 if mouse is not
 installed. -1 otherwise.  nbuttons is number of buttons enabled, =2 }


var recpack  :  registers;

begin
   recpack.ax := 0;
   intr($33, recpack);
   with recpack do
   begin
      mstat := integer(ax);
      nbuttons := integer(bx);
   end
end;

procedure mshow;
{ show mouse cursor }


var  recpack  :  registers;

begin
   recpack.ax := 1;
   intr($33, recpack)
end;

procedure mhide;
{ hide mouse cursor }

var  recpack  :  registers;

begin
   recpack.ax := 2;
   intr($33, recpack)
end;

procedure mpos(var mbt, mx, my : integer);
{ returns position of mouse, coordinates mx, my.
 if mbt=1, left button was pressed
 if mbt=2, right button was pressed
 if mbt=3, both buttons were pressed  }

var  recpack  :  registers;

begin
   recpack.ax := 3;
   intr($33, recpack);
   with recpack do
   begin
      mbt := bx;
      mx := cx;
      my := dx
   end
end;

procedure mput(mx,my : integer);
{ put the mouse cursor at coordinates mx,my.  legal values must be suppled }

var   recpack  :  registers;

begin
   recpack.ax := 4;
   recpack.cx := mx;
   recpack.dx := my;
   intr($33, recpack)
end;

procedure mvlimit(minpos, maxpos : integer);
{ set min and max vertical limits for cursor positions }

var   recpack  :  registers;

begin
   recpack.ax := 8;
   recpack.cx := minpos;
   recpack.dx := maxpos;
   intr($33, recpack)
end;

procedure mhlimit(minpos, maxpos : integer);
{ set min and max vertical limits for cursor positions }

var   recpack  :  registers;

begin
   recpack.ax := 7;
   recpack.cx := minpos;
   recpack.dx := maxpos;
   intr($33, recpack)
end;

procedure mtext(select,mask1,mask2 : integer);
{ select the text cursor.  select=0 gives software cursor, select=1 gives
  hardware cursor.  For select=0 specify screen mask and cursor mask in mask1,
  mask2.  For select=1, specify mask1=0 and mas2=no. scan lines in cursor}

var   recpack  :  registers;

begin
   recpack.ax := 10;
   recpack.cx := mask1;
   recpack.dx := mask2;
   intr($33, recpack)
end;






                                                                                                                               