{$R-}
{$Q-}
{$S-}
{$E-}


unit keybrd;

interface

uses dos;
{if}           CONST
{if}           BackSp  = #8;       PgUp  = #201;      CtrlPgUp = #138;
{if}           Tab     = #9;       PgDn  = #209;      CtrlPgDn = #246;
{if}           Enter   = #13;      Endkey= #207;      CtrlEnd  = #245;
{if}           Esc     = #27;      Home  = #199;      CtrlHome = #247;
{if}           STab    = #143;     Ins   = #210;      Del      = #211;
{if}
{if}           LArr    = #203;      CtrlLArr    = #243;    CtrlPrtsc = #242;
{if}           RArr    = #205;      CtrlRArr    = #244;
{if}           UArr    = #200;
{if}           DArr    = #208;
{if}
{if}
{if}           CtrlA  = #1;          AltA  = #158;        Alt1 = #248;
{if}           CtrlB  = #2;          AltB  = #176;        Alt2 = #249;
{if}           CtrlC  = #3;          AltC  = #174;        Alt3 = #250;
{if}           CtrlD  = #4;          AltD  = #160;        Alt4 = #251;
{if}           CtrlE  = #5;          AltE  = #146;        Alt5 = #252;
{if}           CtrlF  = #6;          AltF  = #161;        Alt6 = #253;
{if}           CtrlG  = #7;          AltG  = #162;        Alt7 = #254;
{if}           CtrlH  = #8;          AltH  = #163;        Alt8 = #255;
{if}           CtrlI  = #9;          AltI  = #151;        Alt9 = #134;
{if}           CtrlJ  = #10;         AltJ  = #164;        Alt0 = #135;
{if}           CtrlK  = #11;         AltK  = #165;        Altminus  = #136;
{if}           CtrlL  = #12;         AltL  = #166;        Altequals = #137;
{if}           CtrlM  = #13;         AltM  = #178;
{if}           CtrlN  = #14;         AltN  = #177;
{if}           CtrlO  = #15;         AltO  = #152;
{if}           CtrlP  = #16;         AltP  = #153;
{if}           CtrlQ  = #17;         AltQ  = #144;
{if}           CtrlR  = #18;         AltR  = #147;
{if}           CtrlS  = #19;         AltS  = #159;
{if}           CtrlT  = #20;         AltT  = #148;
{if}           CtrlU  = #21;         AltU  = #150;
{if}           CtrlV  = #22;         AltV  = #175;
{if}           CtrlW  = #23;         AltW  = #145;
{if}           CtrlX  = #24;         AltX  = #173;
{if}           CtrlY  = #25;         AltY  = #149;
{if}           CtrlZ  = #26;         AltZ  = #172;
{if}
{if}           F1  = #187;              sF1  = #212;
{if}           F2  = #188;              sF2  = #213;
{if}           F3  = #189;              sF3  = #214;
{if}           F4  = #190;              sF4  = #215;
{if}           F5  = #191;              sF5  = #216;
{if}           F6  = #192;              sF6  = #217;
{if}           F7  = #193;              sF7  = #218;
{if}           F8  = #194;              sF8  = #219;
{if}           F9  = #195;              sF9  = #220;
{if}           F10 = #196;              sF10 = #221;
{if}           F11 = #139;              sF11 = #141;
{if}           F12 = #140;              sF12 = #142;
{if}
{if}           CtrlF1  = #222;          AltF1  = #232;
{if}           CtrlF2  = #223;          AltF2  = #233;
{if}           CtrlF3  = #224;          AltF3  = #234;
{if}           CtrlF4  = #225;          AltF4  = #235;
{if}           CtrlF5  = #226;          AltF5  = #236;
{if}           CtrlF6  = #227;          AltF6  = #237;
{if}           CtrlF7  = #228;          AltF7  = #238;
{if}           CtrlF8  = #229;          AltF8  = #239;
{if}           CtrlF9  = #230;          AltF9  = #240;
{if}           CtrlF10 = #231;          AltF10 = #241;
{if}           CtrlF11 = #154;          AltF11 = #156;
{if}           CtrlF12 = #155;          AltF12 = #157;
{if}
{if}          {now the TTT mouse keys}
{if}
{if}           MUp     = #128;
{if}           MDown   = #129;
{if}           MLeft   = #130;
{if}           MRight  = #131;
{if}           MLeftB  = #133;
{if}           MEnter  = #133;
{if}           MEsc    = #132;
{if}           MRightB = #132;
{if}





Function  Alt_Pressed:Boolean;
Function  Ctrl_Pressed:Boolean;
Function  LeftShift_Pressed: Boolean;
Function  RightShift_Pressed: Boolean;
Function  Shift_Pressed: Boolean;
Function  CapsOn: Boolean;
Function  NumOn: Boolean;
Function  ScrollOn: Boolean;
Procedure Set_Caps(On : boolean);
Procedure Set_Num(On : boolean);
Procedure Set_Scroll(On : boolean);


implementation
var  Key_Status_Bits : ^word;
 Function Alt_Pressed:Boolean;
 var
   AltW : word;
 begin
     AltW := swap(Key_Status_Bits^);
     Alt_Pressed := (AltW and $0800) <> 0;
 end;

 Function Ctrl_Pressed:Boolean;
 var
   CtrlW : word;
 begin
     CtrlW := swap(Key_Status_Bits^ );
     Ctrl_Pressed := (CtrlW and $0400) <> 0;
 end;

 Function LeftShift_Pressed: Boolean;
 {}
 var LSW : word;
 begin
     LSW := swap(Key_Status_Bits^ );
     LeftShift_Pressed := (LSW and $0200) <> 0;
 end; {of func LeftShift_Pressed}

 Function RightShift_Pressed: Boolean;
 {}
 var RSW : word;
 begin
     RSW := swap(Key_Status_Bits^ );
     RightShift_Pressed := (RSW and $0100) <> 0;
 end; {of func RightShift_Pressed}

 Function Shift_Pressed: Boolean;
 {}
 var SW : word;
 begin
     SW := swap(Key_Status_Bits^ );
     Shift_Pressed := ((SW and $0200) <> 0) or ((SW and $0100) <> 0);
 end; {of func LeftShift_Pressed}

 Function CapsOn: Boolean;
 {}
 var CapsOnW : word;
 begin
     CapsOnW := swap(Key_Status_Bits^ );
     CapsOn := (CapsOnW and $4000) <> 0;
 end; {of func CapsOn}

 Function NumOn: Boolean;
 {}
 var NumOnW : word;
 begin
     NumOnW := swap(Key_Status_Bits^ );
     NumOn := (NumOnW and $2000) <> 0;
 end; {of func NumOn}

 Function ScrollOn: Boolean;
 {}
 var ScrollOnW : word;
 begin
     ScrollOnW := swap(Key_Status_Bits^ );
     ScrollOn := (ScrollOnW and $1000) <> 0;
 end; {of func ScrollOn}

 Procedure Set_Caps(On : boolean);
 {}
 begin
     If On then
        Key_Status_Bits^  := (Key_Status_Bits^  or $40)
     else
        Key_Status_Bits^  := (Key_Status_Bits^  and $BF);
 end; {of proc Set_Caps}

 Procedure Set_Num(On : boolean);
 {}
 begin
     If On then
        Key_Status_Bits^  := (Key_Status_Bits^  or $20)
     else
        Key_Status_Bits^  := (Key_Status_Bits^  and $DF);
 end; {of proc Set_Num}

 Procedure Set_Scroll(On : boolean);
 {}
 begin
     If On then
        Key_Status_Bits^  := (Key_Status_Bits^  or $10)
     else
        Key_Status_Bits^  := (Key_Status_Bits^  and $EF);
 end; {of proc Set_Scroll}









begin
    Key_Status_Bits := ptr(seg0040,$0017);
    SET_SCROLL(FALSE);
    SET_NUM(FALSE);
    SET_CAPS(FALSE);
end.
