; INT 9 (IRQ1) keyboard handler #6 by Patch - hamell@cs.pdx.edu
; Call Dead Man's Hand at (503) 281-0148
; Grafx/sound source and demos
;
; If you use this code, please inform me and give me due credit

.model large

.code

EXTERN          _keys   QWORD
                ;_keys           db      256 dup(0)

PUBLIC          _keynumpress
                _keynumpress    db      0
oldint9         dd      0
e0flag          db      0

                        PUBLIC  _Set_New_Int9
_Set_New_Int9           PROC    FAR
                push    ds
                push    si
                cli

                mov     ax,cs
                mov     ds,ax
                
                mov     ax,3509h                ; get old INT 9
                int     21h
                mov     si,offset oldint9
                mov     word ptr [si],bx        ; save offset
                mov     word ptr [si + 2],es    ; save segment

                mov     ax,2509h                ; set new INT 9
                mov     dx,seg _New_Int9
                mov     ds,dx
                mov     dx,offset _New_Int9
                int     21h

                sti
                pop     si
                pop     ds
                ret
_Set_New_Int9           ENDP

                        PUBLIC  _Set_Old_Int9
_Set_Old_Int9           PROC    FAR
                push    ds
                push    si
                cli

                mov     ax,cs
                mov     ds,ax
                
                mov     si,offset oldint9
                mov     dx,word ptr [si]        ; load offset
                mov     ds,word ptr [si + 2]    ; load segment
                mov     ax,2509h                ; set new INT 9
                int     21h

                sti
                pop     si
                pop     ds
                ret
_Set_Old_Int9           ENDP

_New_Int9       PROC    FAR
                cli
                push    ds
                push    ax
                push    bx

                mov     ax,cs
                mov     ds,ax
                
                in      al,60h
                mov     ah,al           ; save scan code

; The next 5 lines of code are only necessary on XTs (or so I'm told)
                in      al,61h          ; get control byte
                or      al,80h          ; Clear Keyboard of interrupt request
                out     61h,al          ;
                and     al,7Fh          ; bit 7 = 0 -> ack kbd
                out     61h,al          ;

                cmp     ah,0E0h         ; was it an E0 key?
                jne     setscancode

; E0 key routine
                mov     [e0flag],128
                mov     al,00100000b
                out     20h,al          ; 001 00 000
                                        ; |   |  | 
                                        ; |   |  +---- INT request level
                                        ; |   +------- OCW2
                                        ; +----------- non-specific EOI command
                pop     bx
                pop     ax
                pop     ds
                sti
                iret

setscancode:    mov     bl,ah
                and     bl,01111111b
                add     bl,[e0flag]
                xor     bh,bh                   ; clear for index use
                and     ah,10000000b            ; keep break bit, if set
                xor     ah,10000000b            ; flip bit - 1 means pressed
                                                ;          - 0 means released
                rol     ah,1                    ; put it in bit 0
                mov     _keys[bx],ah            ; set index for key
                mov     [e0flag],0              ; set E0 to 0
                shl     ah,1                    ; set to 2 or 0
                dec     ah                      ; 1 = press, -1 = release
                add     [_keynumpress],ah       ; inc or dec keypress

                mov     al,00100000b    ; Send generic EOI to PIC
                out     20h,al          ; 001 00 000
                                        ; |   |  | 
                                        ; |   |  +---- INT request level
                                        ; |   +------- OCW2
                                        ; +----------- non-specific EOI command
                pop     bx
                pop     ax
                pop     ds
                sti
                iret
_New_Int9       ENDP

                END
